/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class IssueTypeIndexer
extends BaseFieldIndexer {
    public IssueTypeIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return SystemSearchConstants.forIssueType().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forIssueType().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    public void addIndex(Document doc, Issue issue) {
        IssueType issueTypeObject = issue.getIssueTypeObject();
        if (issueTypeObject != null) {
            this.indexKeyword(doc, this.getDocumentFieldId(), issueTypeObject.getId(), issue);
        }
    }
}

