/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearcherCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexManager.class);
    private static final ThreadLocal<SearcherCache> THREAD_LOCAL = new ThreadLocal();
    private Map<IndexDirectoryFactory.Name, IndexSearcher> entitySearchers = new EnumMap<IndexDirectoryFactory.Name, IndexSearcher>(IndexDirectoryFactory.Name.class);

    SearcherCache() {
    }

    static SearcherCache getThreadLocalCache() {
        SearcherCache threadLocalSearcherCache = THREAD_LOCAL.get();
        if (threadLocalSearcherCache == null) {
            threadLocalSearcherCache = new SearcherCache();
            THREAD_LOCAL.set(threadLocalSearcherCache);
        }
        return threadLocalSearcherCache;
    }

    IndexSearcher retrieveEntitySearcher(IssueIndexer issueIndexer, IndexingConfiguration indexingConfiguration, IndexDirectoryFactory.Name index) {
        if (!this.entitySearchers.containsKey((Object)index)) {
            try {
                this.entitySearchers.put(index, issueIndexer.openEntitySearcher(index));
            }
            catch (RuntimeException e) {
                throw new SearchUnavailableException(e, indexingConfiguration.isIndexAvailable());
            }
        }
        return this.entitySearchers.get((Object)index);
    }

    void closeSearchers() {
        for (Map.Entry<IndexDirectoryFactory.Name, IndexSearcher> searcher : this.entitySearchers.entrySet()) {
            try {
                this.closeSearcher(searcher.getValue());
            }
            catch (Exception e) {
                log.error("Error while resetting searcher: " + (Object)((Object)searcher.getKey()) + " message: " + e.getMessage(), (Throwable)e);
            }
        }
        this.entitySearchers = new EnumMap<IndexDirectoryFactory.Name, IndexSearcher>(IndexDirectoryFactory.Name.class);
    }

    private void closeSearcher(IndexSearcher searcher) throws IOException {
        if (searcher != null) {
            searcher.close();
        }
    }
}

