/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryLinkFactory
implements WebItemProvider {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryLinkFactory.class);
    private final UserIssueHistoryManager userHistoryManager;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private static final int MAX_LABEL_LENGTH = 30;

    public IssueHistoryLinkFactory(VelocityRequestContextFactory velocityRequestContextFactory, UserIssueHistoryManager userHistoryManager, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactory) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.userHistoryManager = userHistoryManager;
        this.applicationProperties = applicationProperties;
        this.i18nFactory = i18nFactory;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ApplicationUser user = (ApplicationUser)context.get("user");
        List history = this.userHistoryManager.getShortIssueHistory(user);
        ArrayList links = Lists.newArrayList();
        if (!history.isEmpty()) {
            VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            String baseUrl = requestContext.getBaseUrl();
            int maxItems = this.getMaxDropdownItems();
            int weight = 0;
            for (int i = 0; i < maxItems - 1 && i < history.size(); ++i) {
                String iconUrl;
                Issue issue = (Issue)history.get(i);
                String label = issue.getKey() + " " + issue.getSummary();
                String shortLabel = label;
                if (shortLabel.length() > 30) {
                    shortLabel = shortLabel.substring(0, 30) + "...";
                }
                if (!(iconUrl = issue.getIssueTypeObject().getIconUrl()).startsWith("http://") && !iconUrl.startsWith("https://")) {
                    iconUrl = baseUrl + iconUrl;
                }
                links.add(new WebFragmentBuilder(weight += 10).id("issue_lnk_" + issue.getId()).label(shortLabel).title(label).addParam("class", "issue-link").addParam("data-issue-key", issue.getKey()).addParam("iconUrl", iconUrl).webItem("find_link/issues_history_main").url(baseUrl + "/browse/" + issue.getKey()).build());
            }
            if (history.size() >= maxItems) {
                I18nHelper i18n = this.i18nFactory.getInstance(user);
                links.add(new WebFragmentBuilder(weight + 10).id("issue_lnk_more").label(i18n.getText("menu.issues.history.more")).title(i18n.getText("menu.issues.history.more.desc")).addParam("class", "filter-link").addParam("data-filter-id", "-3").webItem("find_link/issues_history_main").url(baseUrl + "/issues/?filter=-3").build());
            }
        }
        return links;
    }

    private int getMaxDropdownItems() {
        int maxItems = 6;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.issue.history.dropdown.items"));
        }
        catch (NumberFormatException e) {
            log.warn("Incorrect format of property 'jira.max.history.dropdown.items'.  Should be a number.");
        }
        return maxItems;
    }
}

