/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.OptionSetManagerImpl;
import com.atlassian.jira.issue.fields.option.OptionSetPersister;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachedOptionSetManager
implements OptionSetManager {
    private final Cache<Long, OptionSet> cache;
    private final OptionSetManagerImpl optionSetManager;

    public CachedOptionSetManager(OptionSetPersister optionSetPersister, ConstantsManager constantsManager, CacheManager cacheManager) {
        this.optionSetManager = new OptionSetManagerImpl(optionSetPersister, constantsManager);
        this.cache = cacheManager.getCache(CachedOptionSetManager.class.getName() + ".cache", (CacheLoader)new OptionSetLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    public OptionSet getOptionsForConfig(@Nonnull FieldConfig config) {
        return (OptionSet)this.cache.get((Object)((FieldConfig)Assertions.notNull((String)"config", (Object)config)).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet createOptionSet(@Nonnull FieldConfig config, Collection optionIds) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            OptionSet optionSet = this.optionSetManager.createOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet updateOptionSet(@Nonnull FieldConfig config, Collection optionIds) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            OptionSet optionSet = this.optionSetManager.updateOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    public void removeOptionSet(@Nonnull FieldConfig config) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            this.optionSetManager.removeOptionSet(config);
        }
        finally {
            this.cache.remove((Object)config.getId());
        }
    }

    class OptionSetLoader
    implements CacheLoader<Long, OptionSet> {
        OptionSetLoader() {
        }

        public OptionSet load(Long fieldConfigId) {
            FieldConfigManager fieldConfigManager = (FieldConfigManager)ComponentAccessor.getComponent(FieldConfigManager.class);
            FieldConfig fieldConfig = fieldConfigManager.getFieldConfig(fieldConfigId);
            return CachedOptionSetManager.this.optionSetManager.getOptionsForConfig(fieldConfig);
        }
    }
}

