/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeCreatedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeDeletedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeUpdatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeSchemeManagerImpl
implements IssueTypeSchemeManager {
    private final FieldConfigSchemeManager configSchemeManager;
    private final OptionSetManager optionSetManager;
    private final GenericConfigManager genericConfigManager;
    private final ConstantsManager constantsManager;
    private EventPublisher eventPublisher;

    public IssueTypeSchemeManagerImpl(FieldConfigSchemeManager configSchemeManager, OptionSetManager optionSetManager, GenericConfigManager genericConfigManager, ConstantsManager constantsManager, EventPublisher eventPublisher) {
        this.configSchemeManager = configSchemeManager;
        this.optionSetManager = optionSetManager;
        this.genericConfigManager = genericConfigManager;
        this.constantsManager = constantsManager;
        this.eventPublisher = eventPublisher;
    }

    public FieldConfigScheme create(String schemeName, String schemeDescription, List optionIds) {
        FieldConfigScheme configScheme = this.configSchemeManager.createFieldConfigScheme(new FieldConfigScheme.Builder().setName(schemeName).setDescription(schemeDescription).toFieldConfigScheme(), null, FieldConfigSchemeManager.ALL_ISSUE_TYPES, this.getIssueTypeField());
        FieldConfig config = configScheme.getOneAndOnlyConfig();
        this.optionSetManager.createOptionSet(config, (Collection)optionIds);
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeCreatedEvent(configScheme));
        return configScheme;
    }

    public FieldConfigScheme update(FieldConfigScheme configScheme, Collection optionIds) {
        configScheme = this.configSchemeManager.updateFieldConfigScheme(configScheme);
        FieldConfig config = configScheme.getOneAndOnlyConfig();
        this.optionSetManager.updateOptionSet(config, optionIds);
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeUpdatedEvent(configScheme));
        return configScheme;
    }

    public FieldConfigScheme getDefaultIssueTypeScheme() {
        Long schemeId = this.getDefaultIssueTypeSchemeId();
        return this.configSchemeManager.getFieldConfigScheme(schemeId);
    }

    public boolean isDefaultIssueTypeScheme(FieldConfigScheme configScheme) {
        return this.getDefaultIssueTypeSchemeId().equals(configScheme.getId());
    }

    private ConfigurableField getIssueTypeField() {
        return this.getFieldManager().getConfigurableField("issuetype");
    }

    private Long getDefaultIssueTypeSchemeId() {
        String s = ComponentAccessor.getApplicationProperties().getString("jira.scheme.default.issue.type");
        return new Long(s);
    }

    public void addOptionToDefault(String id) {
        FieldConfigScheme defaultIssueTypeScheme = this.getDefaultIssueTypeScheme();
        ArrayList<String> optionIds = new ArrayList<String>(this.optionSetManager.getOptionsForConfig(defaultIssueTypeScheme.getOneAndOnlyConfig()).getOptionIds());
        optionIds.add(id);
        this.update(defaultIssueTypeScheme, optionIds);
    }

    public Collection<FieldConfigScheme> getAllRelatedSchemes(final String optionId) {
        List configs = this.configSchemeManager.getConfigSchemesForField(this.getIssueTypeField());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)configs, (Predicate)new Predicate<FieldConfigScheme>(){

            public boolean apply(@Nullable FieldConfigScheme configScheme) {
                Collection optionIds = IssueTypeSchemeManagerImpl.this.optionSetManager.getOptionsForConfig(configScheme.getOneAndOnlyConfig()).getOptionIds();
                return optionIds.contains(optionId);
            }
        }));
    }

    public void removeOptionFromAllSchemes(String optionId) {
        Collection<FieldConfigScheme> relatedSchemes = this.getAllRelatedSchemes(optionId);
        for (FieldConfigScheme configScheme : relatedSchemes) {
            Collection optionIds = this.optionSetManager.getOptionsForConfig(configScheme.getOneAndOnlyConfig()).getOptionIds();
            optionIds.remove(optionId);
            this.update(configScheme, optionIds);
        }
    }

    public void deleteScheme(FieldConfigScheme configScheme) {
        this.configSchemeManager.removeFieldConfigScheme(configScheme.getId());
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeDeletedEvent(configScheme));
    }

    public List<FieldConfigScheme> getAllSchemes() {
        ArrayList<FieldConfigScheme> schemes = new ArrayList<FieldConfigScheme>(this.configSchemeManager.getConfigSchemesForField((ConfigurableField)this.getFieldManager().getIssueTypeField()));
        Collections.sort(schemes, new SchemeComparator());
        return schemes;
    }

    FieldManager getFieldManager() {
        return ComponentAccessor.getFieldManager();
    }

    public IssueType getDefaultValue(Issue issue) {
        FieldConfig config = this.configSchemeManager.getRelevantConfig((IssueContext)issue, this.getIssueTypeField());
        return this.getDefaultValue(config);
    }

    public IssueType getDefaultValue(FieldConfig config) {
        if (config != null) {
            String issueTypeId = (String)this.genericConfigManager.retrieve("DefaultValue", config.getId().toString());
            return ComponentAccessor.getConstantsManager().getIssueTypeObject(issueTypeId);
        }
        return null;
    }

    public IssueType getDefaultValue(GenericValue project) {
        if (project != null) {
            IssueTypeField issueTypeField = this.getFieldManager().getIssueTypeField();
            FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(project.getLong("id"), null));
            return this.getDefaultValue(relevantConfig);
        }
        return null;
    }

    public IssueType getDefaultIssueType(Project project) {
        if (project != null) {
            IssueTypeField issueTypeField = this.getFieldManager().getIssueTypeField();
            FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(project.getId(), null));
            return this.getDefaultValue(relevantConfig);
        }
        return null;
    }

    public void setDefaultValue(FieldConfig config, String optionId) {
        this.genericConfigManager.update("DefaultValue", config.getId().toString(), (Object)optionId);
        this.getFieldManager().refresh();
    }

    public FieldConfigScheme getConfigScheme(GenericValue project) {
        return this.configSchemeManager.getRelevantConfigScheme((IssueContext)new IssueContextImpl(project != null ? project.getLong("id") : null, null), (ConfigurableField)this.getFieldManager().getIssueTypeField());
    }

    public FieldConfigScheme getConfigScheme(Project project) {
        return this.configSchemeManager.getRelevantConfigScheme((IssueContext)new IssueContextImpl(project.getId(), null), (ConfigurableField)this.getFieldManager().getIssueTypeField());
    }

    public Collection<IssueType> getIssueTypesForProject(GenericValue project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project);
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, true);
    }

    public Collection<IssueType> getIssueTypesForProject(Project project) {
        return this.getIssueTypesForProject(project.getGenericValue());
    }

    public Collection<IssueType> getIssueTypesForDefaultScheme() {
        FieldConfigScheme fieldConfigScheme = this.getDefaultIssueTypeScheme();
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, true);
    }

    public Collection<IssueType> getNonSubTaskIssueTypesForProject(Project project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project.getGenericValue());
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, false, true);
    }

    public Collection<IssueType> getSubTaskIssueTypesForProject(Project project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project.getGenericValue());
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, false);
    }

    private Collection<IssueType> getIssueTypesForConfigScheme(FieldConfigScheme fieldConfigScheme, boolean includeSubTasks, boolean includeNonSubTaskIssueTypes) {
        FieldConfig config = fieldConfigScheme.getOneAndOnlyConfig();
        Collection options = this.optionSetManager.getOptionsForConfig(config).getOptions();
        ArrayList<IssueType> issueTypeObjects = new ArrayList<IssueType>();
        for (Option option : options) {
            IssueConstantOption issueTypeOption = (IssueConstantOption)option;
            IssueType issueType = this.constantsManager.getIssueTypeObject(issueTypeOption.getId());
            boolean isSubTask = issueType.isSubTask();
            if ((!includeSubTasks || !isSubTask) && (!includeNonSubTaskIssueTypes || isSubTask)) continue;
            issueTypeObjects.add(issueType);
        }
        return issueTypeObjects;
    }

    class SchemeComparator
    implements Comparator<FieldConfigScheme> {
        private final Long defaultId;

        SchemeComparator() {
            this.defaultId = IssueTypeSchemeManagerImpl.this.getDefaultIssueTypeScheme().getId();
        }

        @Override
        public int compare(FieldConfigScheme one, FieldConfigScheme two) {
            if (this.defaultId != null) {
                Long oneId = one.getId();
                Long twoId = two.getId();
                if (oneId != null && one.getId().compareTo(this.defaultId) == 0) {
                    return -1;
                }
                if (twoId != null && two.getId().compareTo(this.defaultId) == 0) {
                    return 1;
                }
            }
            String oneName = one.getName();
            String twoName = two.getName();
            if (oneName == null) {
                return -1;
            }
            if (twoName == null) {
                return 1;
            }
            return oneName.compareToIgnoreCase(twoName);
        }
    }
}

