/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import java.util.Map;

public class CommentVisibility {
    private String commentLevel;
    private static final String ROLE_PREFIX = "role:";
    private static final String GROUP_PREFIX = "group:";

    public CommentVisibility(Map params, String paramName) {
        String[] value = (String[])params.get(paramName);
        if (value != null && value.length > 0) {
            this.commentLevel = value[0];
            if (this.commentLevel != null && "".equals(this.commentLevel.trim())) {
                this.commentLevel = null;
            }
        }
    }

    public CommentVisibility(String commentLevel) {
        this.commentLevel = commentLevel;
    }

    public String getRoleLevel() {
        if (this.commentLevel != null && this.commentLevel.startsWith(ROLE_PREFIX)) {
            return this.commentLevel.substring(ROLE_PREFIX.length());
        }
        return null;
    }

    public String getGroupLevel() {
        if (this.commentLevel != null && this.commentLevel.startsWith(GROUP_PREFIX)) {
            return this.commentLevel.substring(GROUP_PREFIX.length());
        }
        return null;
    }

    public static String getCommentLevelFromLevels(String groupLevel, Long roleLevelId) {
        if (groupLevel != null) {
            return GROUP_PREFIX + groupLevel;
        }
        if (roleLevelId != null) {
            return ROLE_PREFIX + roleLevelId;
        }
        return null;
    }

    public static String getRoleLevelWithPrefix(String roleLevel) {
        return ROLE_PREFIX + roleLevel;
    }
}

