/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager;

import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.map.NotNullHashMap;
import com.thoughtworks.xstream.XStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenericConfigManager
implements GenericConfigManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultGenericConfigManager.class);
    private final OfBizDelegator delegator;

    public DefaultGenericConfigManager(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    public void create(String dataType, String key, @Nullable Object obj) {
        if (obj != null) {
            String xml = this.toXml(obj);
            log.debug(obj + " stored as " + xml);
            Map fields = this.toFieldsMap(dataType, key, xml);
            EntityUtils.createValue("GenericConfiguration", fields);
        }
    }

    public void update(String dataType, String key, @Nullable Object obj) {
        if (obj != null) {
            Map fields = this.toFieldsMap(dataType, key, null);
            try {
                List gvs = this.delegator.findByAnd("GenericConfiguration", fields);
                String xml = this.toXml(obj);
                if (gvs != null && !gvs.isEmpty()) {
                    GenericValue gv = (GenericValue)gvs.iterator().next();
                    gv.setString("xmlvalue", xml);
                    gv.store();
                }
                fields.put("xmlvalue", xml);
                EntityUtils.createValue("GenericConfiguration", fields);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        } else {
            this.remove(dataType, key);
        }
    }

    public Object retrieve(String dataType, String key) {
        Map fields = this.toFieldsMap(dataType, key, null);
        List gvs = this.delegator.findByAnd("GenericConfiguration", fields);
        if (gvs != null && !gvs.isEmpty()) {
            GenericValue gv = (GenericValue)gvs.iterator().next();
            String xml = gv.getString("xmlvalue");
            return this.fromXml(xml);
        }
        return null;
    }

    public void remove(String dataType, String key) {
        Map fields = this.toFieldsMap(dataType, key, null);
        this.delegator.removeByAnd("GenericConfiguration", fields);
    }

    private Map toFieldsMap(String dataType, String key, String xml) {
        NotNullHashMap<String, String> fields = new NotNullHashMap<String, String>();
        fields.put("datatype", dataType);
        fields.put("datakey", key);
        fields.put("xmlvalue", xml);
        return fields;
    }

    private String toXml(Object obj) {
        if (obj != null) {
            XStream xStream = new XStream();
            String xml = xStream.toXML(obj);
            return xml;
        }
        return null;
    }

    private Object fromXml(String xml) {
        if (StringUtils.isNotEmpty((String)xml)) {
            XStream xStream = new XStream();
            return xStream.fromXML(xml);
        }
        return null;
    }
}

