/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypeImpl;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.IssuePropertyJql;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AliasClauseInformation
implements ClauseInformation {
    private final JiraDataTypeImpl jiraDataType;
    private final Set<Operator> operators;
    private final String alias;
    private final String luceneFieldName;
    private final ClauseNames clauseNames;
    private final String pluginName;
    private final IssuePropertyJql issuePropertyJql;
    private final boolean autoComplete;
    private final boolean orderable;

    public AliasClauseInformation(IndexDocumentConfiguration.Type type, String alias, String luceneFieldName, ClauseNames clauseNames, IssuePropertyJql issuePropertyJql, String pluginName) {
        this.issuePropertyJql = (IssuePropertyJql)Preconditions.checkNotNull((Object)issuePropertyJql);
        this.jiraDataType = ((IndexDocumentConfiguration.Type)Preconditions.checkNotNull((Object)type)).getJiraDataType();
        this.operators = ((IndexDocumentConfiguration.Type)Preconditions.checkNotNull((Object)type)).getOperators();
        this.alias = (String)Preconditions.checkNotNull((Object)alias);
        this.luceneFieldName = (String)Preconditions.checkNotNull((Object)luceneFieldName);
        this.clauseNames = (ClauseNames)Preconditions.checkNotNull((Object)clauseNames);
        this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName);
        this.autoComplete = ((IndexDocumentConfiguration.Type)Preconditions.checkNotNull((Object)type)).isAutoCompleteEnabled();
        this.orderable = ((IndexDocumentConfiguration.Type)Preconditions.checkNotNull((Object)type)).isOrderable();
    }

    public ClauseNames getJqlClauseNames() {
        return this.clauseNames;
    }

    @Nullable
    public String getIndexField() {
        return this.luceneFieldName;
    }

    @Nullable
    public String getFieldId() {
        return this.alias;
    }

    public Set<Operator> getSupportedOperators() {
        return this.operators;
    }

    public JiraDataType getDataType() {
        return this.jiraDataType;
    }

    @Nonnull
    public String getPluginName() {
        return this.pluginName;
    }

    public IssuePropertyJql getIssuePropertyJql() {
        return this.issuePropertyJql;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public boolean isOrderable() {
        return this.orderable;
    }
}

