/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldOption;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldOptionMapper;
import com.atlassian.jira.imports.project.validation.CustomFieldOptionMapperValidator;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldOptionMapperValidatorImpl
implements CustomFieldOptionMapperValidator {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldOptionMapperValidatorImpl.class);
    private final OptionsManager optionsManager;

    public CustomFieldOptionMapperValidatorImpl(OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
    }

    @Override
    public void validateMappings(I18nHelper i18nHelper, BackupProject backupProject, CustomFieldOptionMapper customFieldOptionMapper, CustomFieldMapper customFieldMapper, Map customFieldValueMessageSets) {
        for (String oldId : customFieldOptionMapper.getRequiredOldIds()) {
            ExternalCustomFieldOption oldCustomFieldOption = customFieldOptionMapper.getCustomFieldOption(oldId);
            if (oldCustomFieldOption == null) {
                log.warn("Cannot map required Custom Field Option '" + oldId + "' because there was no configuration for it in the import file. This is orphan data that is no longer valid.");
                continue;
            }
            if (this.isValidContext(oldCustomFieldOption, backupProject)) {
                MessageSet messageSet;
                String newId = customFieldOptionMapper.getMappedId(oldId);
                if (newId == null) {
                    String nameFor = this.getDisplayNameFor(oldCustomFieldOption, customFieldOptionMapper);
                    if (oldCustomFieldOption.getParentId() == null) {
                        messageSet = this.getMessageSetForFieldId(oldCustomFieldOption.getCustomFieldId(), customFieldValueMessageSets);
                        messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.does.not.exist", customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()), nameFor));
                        messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()) + "' requires option '" + nameFor + "' for the import but it does not exist in the current JIRA instance.");
                        continue;
                    }
                    String parentName = this.getParentOptionValue(oldCustomFieldOption, customFieldOptionMapper);
                    String childOptionValue = oldCustomFieldOption.getValue();
                    MessageSet messageSet2 = this.getMessageSetForFieldId(oldCustomFieldOption.getCustomFieldId(), customFieldValueMessageSets);
                    messageSet2.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.child.does.not.exist", customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()), parentName, childOptionValue));
                    messageSet2.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()) + "' requires option with parent '" + parentName + "' and value '" + childOptionValue + "' for the import but it does not exist in the current JIRA instance.");
                    continue;
                }
                Option newOption = this.optionsManager.findByOptionId(new Long(newId));
                if (newOption == null) {
                    String displayNameFor = this.getDisplayNameFor(oldCustomFieldOption, customFieldOptionMapper);
                    MessageSet messageSet3 = this.getMessageSetForFieldId(oldCustomFieldOption.getCustomFieldId(), customFieldValueMessageSets);
                    messageSet3.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.does.not.exist", customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()), displayNameFor));
                    messageSet3.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()) + "' requires option '" + displayNameFor + "' for the import but it does not exist in the current JIRA instance.");
                    continue;
                }
                messageSet = this.getMessageSetForFieldId(oldCustomFieldOption.getCustomFieldId(), customFieldValueMessageSets);
                this.validateNewOption(i18nHelper, customFieldOptionMapper, customFieldMapper, messageSet, oldCustomFieldOption, newOption);
                continue;
            }
            log.debug("Custom Field Option '" + oldCustomFieldOption.getValue() + " (" + oldCustomFieldOption.getId() + ") from the backup file is being safely ignored because it is invalid.");
        }
    }

    private String getDisplayNameFor(ExternalCustomFieldOption oldCustomFieldOption, CustomFieldOptionMapper customFieldOptionMapper) {
        if (oldCustomFieldOption.getParentId() == null) {
            return oldCustomFieldOption.getValue();
        }
        String parentName = this.getParentOptionValue(oldCustomFieldOption, customFieldOptionMapper);
        return parentName + " - " + oldCustomFieldOption.getValue();
    }

    String getParentOptionValue(ExternalCustomFieldOption oldCustomFieldOption, CustomFieldOptionMapper customFieldOptionMapper) {
        ExternalCustomFieldOption parentCustomFieldOption = customFieldOptionMapper.getCustomFieldOption(oldCustomFieldOption.getParentId());
        String parentName = parentCustomFieldOption == null ? "???" : parentCustomFieldOption.getValue();
        return parentName;
    }

    MessageSet getMessageSetForFieldId(String oldCustomFieldId, Map customFieldValueMessageSets) {
        MessageSet customFieldMessageSet = (MessageSet)customFieldValueMessageSets.get(oldCustomFieldId);
        if (customFieldMessageSet == null) {
            customFieldMessageSet = new MessageSetImpl();
            customFieldValueMessageSets.put(oldCustomFieldId, customFieldMessageSet);
        }
        return customFieldMessageSet;
    }

    void validateNewOption(I18nHelper i18nHelper, CustomFieldOptionMapper customFieldOptionMapper, CustomFieldMapper customFieldMapper, MessageSet messageSet, ExternalCustomFieldOption oldCustomFieldOption, Option newOption) {
        String mappedCustomFieldId = customFieldMapper.getMappedId(oldCustomFieldOption.getCustomFieldId());
        FieldConfig relatedCustomField = newOption.getRelatedCustomField();
        CustomField newCustomField = relatedCustomField.getCustomField();
        Long newCustomFieldId = newCustomField.getIdAsLong();
        if (!newCustomFieldId.toString().equals(mappedCustomFieldId)) {
            String nameFor = this.getDisplayNameFor(oldCustomFieldOption, customFieldOptionMapper);
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.wrong.custom.field", customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()), nameFor));
            messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldCustomFieldOption.getCustomFieldId()) + "' does not contain option '" + nameFor + "', the import can not continue.");
        } else {
            this.validateOptionLevels(i18nHelper, customFieldOptionMapper, messageSet, oldCustomFieldOption, newOption);
        }
    }

    void validateOptionLevels(I18nHelper i18nHelper, CustomFieldOptionMapper customFieldOptionMapper, MessageSet messageSet, ExternalCustomFieldOption oldCustomFieldOption, Option newOption) {
        if (oldCustomFieldOption.getParentId() == null) {
            if (newOption.getParentOption() != null) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.old.parent.new.child", oldCustomFieldOption.getValue(), newOption.getValue()));
                messageSet.addErrorMessageInEnglish("The parent custom field option '" + oldCustomFieldOption.getValue() + "' from the import file was mapped to a child option ('" + newOption.getValue() + "') in the current JIRA instance.");
            }
        } else if (newOption.getParentOption() == null) {
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.old.child.new.parent", oldCustomFieldOption.getValue(), newOption.getValue()));
            messageSet.addErrorMessageInEnglish("The child custom field option '" + oldCustomFieldOption.getValue() + "' from the import file was mapped to a parent option ('" + newOption.getValue() + "') in the current JIRA instance.");
        } else {
            String mappedParentId = customFieldOptionMapper.getMappedId(oldCustomFieldOption.getParentId());
            if (mappedParentId == null) {
                String displayNameFor = this.getDisplayNameFor(oldCustomFieldOption, customFieldOptionMapper);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.childs.parent.not.mapped", displayNameFor));
                messageSet.addErrorMessageInEnglish("The child custom field option '" + displayNameFor + "' from the import file has a parent option that is not mapped.");
            } else if (!mappedParentId.equals(newOption.getParentOption().getOptionId().toString())) {
                String nameFor = this.getDisplayNameFor(oldCustomFieldOption, customFieldOptionMapper);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.option.old.childs.parent.mapping.invalid", nameFor, newOption.getValue()));
                messageSet.addErrorMessageInEnglish("The child custom field option '" + nameFor + "' from the import file is mapped to option ('" + newOption.getValue() + "') in the current JIRA instance, but their parents aren''t mapped to each other.");
            }
        }
    }

    boolean isValidContext(ExternalCustomFieldOption customFieldOption, BackupProject backupProject) {
        ExternalCustomFieldConfiguration customFieldConfiguration = backupProject.getCustomFieldConfiguration(customFieldOption.getCustomFieldId());
        if (customFieldConfiguration == null) {
            return false;
        }
        return customFieldConfiguration.getConfigurationSchemeId().equals(customFieldOption.getFieldConfigId());
    }
}

