/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.MapperEntityRegister;
import com.atlassian.jira.util.dbc.Null;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SimpleEntityMapperHandler
implements ImportOfBizEntityHandler {
    public static final String PRIORITY_ENTITY_NAME = "Priority";
    public static final String STATUS_ENTITY_NAME = "Status";
    public static final String RESOLUTION_ENTITY_NAME = "Resolution";
    public static final String PROJECT_ROLE_ENTITY_NAME = "ProjectRole";
    private final MapperEntityRegister mapperEntityRegister;
    private final String entityTypeName;

    public SimpleEntityMapperHandler(String entityTypeName, MapperEntityRegister mapperEntityRegister) {
        Null.not("entityTypeName", entityTypeName);
        this.mapperEntityRegister = mapperEntityRegister;
        this.entityTypeName = entityTypeName;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if (this.entityTypeName.equals(entityName)) {
            String id = attributes.get("id");
            String name = attributes.get("name");
            if (StringUtils.isBlank((String)id)) {
                throw new ParseException("Encountered an entity of type '" + this.entityTypeName + "' with a missing ID.");
            }
            if (StringUtils.isBlank((String)name)) {
                throw new ParseException("The name of " + this.entityTypeName + " '" + id + "' is missing.");
            }
            this.mapperEntityRegister.registerOldValue(id, name);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleEntityMapperHandler handler = (SimpleEntityMapperHandler)o;
        if (this.entityTypeName != null ? !this.entityTypeName.equals(handler.entityTypeName) : handler.entityTypeName != null) {
            return false;
        }
        return !(this.mapperEntityRegister != null ? !this.mapperEntityRegister.equals(handler.mapperEntityRegister) : handler.mapperEntityRegister != null);
    }

    public int hashCode() {
        int result = this.mapperEntityRegister != null ? this.mapperEntityRegister.hashCode() : 0;
        result = 31 * result + (this.entityTypeName != null ? this.entityTypeName.hashCode() : 0);
        return result;
    }
}

