/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.mention;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Set;

@EventComponent
public class MentionEventListener {
    private final MentionService mentionService;
    private final NotificationSchemeManager notificationSchemeManager;

    public MentionEventListener(MentionService mentionService, NotificationSchemeManager notificationSchemeManager) {
        this.notificationSchemeManager = (NotificationSchemeManager)Assertions.notNull((String)"notificationSchemeManager", (Object)notificationSchemeManager);
        this.mentionService = (MentionService)Assertions.notNull((String)"mentionService", (Object)mentionService);
    }

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        Long eventTypeId = event.getEventTypeId();
        ApplicationUser remoteUser = event.getUser();
        Set recipients = this.notificationSchemeManager.getRecipients(event);
        if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
            Comment originalComment = (Comment)event.getParams().get("originalcomment");
            this.mentionService.sendCommentMentions(remoteUser, recipients, event.getComment(), originalComment);
        } else if (eventTypeId.equals(EventType.ISSUE_CREATED_ID)) {
            this.mentionService.sendIssueCreateMentions(remoteUser, recipients, event.getIssue());
        } else if (eventTypeId.equals(EventType.ISSUE_UPDATED_ID)) {
            this.mentionService.sendIssueEditMentions(remoteUser, recipients, event.getIssue(), event.getComment());
        } else if (eventTypeId.equals(EventType.ISSUE_COMMENT_DELETED_ID)) {
            this.mentionService.sendIssueEditMentions(remoteUser, recipients, event.getIssue(), event.getComment());
        } else if (event.getComment() != null) {
            this.mentionService.sendCommentMentions(remoteUser, recipients, event.getComment(), null);
        }
    }
}

