/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard.permission;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.DashboardItemStateVisitor;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.Vote;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.plugins.GadgetLocationTranslator;
import com.atlassian.gadgets.plugins.PluginGadgetSpec;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.dashboard.permission.GadgetPermissionManager;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraGadgetPermissionManager
implements GadgetPermissionManager {
    private static final Logger log = LoggerFactory.getLogger(JiraGadgetPermissionManager.class);
    private static final Pattern PLUGIN_KEY_PATTERN = Pattern.compile(".*rest\\/gadgets\\/.*\\/g\\/([^\\/]+):([^\\/]+).*", 2);
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;
    private final DashboardPermissionService permissionService;

    public JiraGadgetPermissionManager(PermissionManager permissionManager, PluginAccessor pluginAccessor, DashboardPermissionService permissionService) {
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.permissionService = permissionService;
    }

    @Override
    public Vote voteOn(PluginGadgetSpec pluginGadgetSpec, ApplicationUser remoteUser) {
        String[] roles;
        Assertions.notNull((String)"pluginGadgetSpec", (Object)pluginGadgetSpec);
        if (!this.evaluateConditions(pluginGadgetSpec)) {
            return Vote.DENY;
        }
        String roleString = pluginGadgetSpec.getParameter("roles-required");
        if (StringUtils.isBlank((String)roleString)) {
            return Vote.ALLOW;
        }
        if (this.permissionManager.hasPermission(0, remoteUser)) {
            return Vote.ALLOW;
        }
        for (String role : roles = StringUtils.split((String)roleString)) {
            int permission = Permissions.getType((String)role);
            if (permission == -1) {
                log.warn("Invalid role-required specified for gadget '" + pluginGadgetSpec.getKey() + "': '" + role + "'");
                return Vote.PASS;
            }
            if (!(Permissions.isGlobalPermission((int)permission) ? !this.permissionManager.hasPermission(permission, remoteUser) : !this.hasProjectsPermission(permission, remoteUser))) continue;
            return Vote.DENY;
        }
        return Vote.ALLOW;
    }

    @Override
    public DashboardState filterGadgets(DashboardState dashboardState, ApplicationUser remoteUser) {
        Assertions.notNull((String)"dashboardState", (Object)dashboardState);
        boolean isWritable = this.permissionService.isWritableBy(dashboardState.getId(), remoteUser == null ? null : remoteUser.getName());
        if (isWritable) {
            return dashboardState;
        }
        Iterable<Iterable<DashboardItemState>> columns = this.filterGadgetsThatUserCanNotSee(dashboardState, remoteUser);
        return DashboardState.dashboard((DashboardState)dashboardState).dashboardColumns(columns).build();
    }

    @Override
    public Option<PluginGadgetSpec> getPluginGadgetSpec(URI gadgetUri) {
        if (gadgetUri == null) {
            return Option.none();
        }
        URI gadgetSpecUri = this.getGadgetLocationTranslator().translate(gadgetUri);
        String moduleKey = this.extractModuleKey(gadgetSpecUri.toASCIIString());
        return moduleKey == null ? Option.none() : this.getPluginGadgetSpecFromModuleKey(moduleKey);
    }

    @VisibleForTesting
    String extractModuleKey(String gadgetUri) {
        Matcher matcher = PLUGIN_KEY_PATTERN.matcher(gadgetUri);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return matcher.group(1) + ":" + matcher.group(2);
        }
        return null;
    }

    private Option<PluginGadgetSpec> getPluginGadgetSpecFromModuleKey(String completeGadgetModuleKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(completeGadgetModuleKey);
        if (moduleDescriptor == null) {
            return Option.none();
        }
        Object module = moduleDescriptor.getModule();
        if (module instanceof PluginGadgetSpec) {
            return Option.some((Object)((PluginGadgetSpec)module));
        }
        return Option.none();
    }

    private boolean evaluateConditions(PluginGadgetSpec gadgetSpec) {
        Map context = DefaultWebFragmentContext.get();
        return gadgetSpec.getEnabledCondition().shouldDisplay(context) && gadgetSpec.getLocalCondition().shouldDisplay(context);
    }

    private boolean hasProjectsPermission(int permission, ApplicationUser user) {
        try {
            return this.permissionManager.hasProjects(new ProjectPermissionKey(permission), user);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private GadgetLocationTranslator getGadgetLocationTranslator() {
        return (GadgetLocationTranslator)ComponentAccessor.getOSGiComponentInstanceOfType(GadgetLocationTranslator.class);
    }

    private Iterable<Iterable<DashboardItemState>> filterGadgetsThatUserCanNotSee(DashboardState dashboardState, final ApplicationUser remoteUser) {
        Predicate<DashboardItemState> isUserAbleToSeeDashboardItem = new Predicate<DashboardItemState>(){

            public boolean apply(DashboardItemState dashboardItemState) {
                return (Boolean)dashboardItemState.accept((DashboardItemStateVisitor)new DashboardItemStateVisitor<Boolean>(){

                    public Boolean visit(GadgetState gadgetState) {
                        Option<PluginGadgetSpec> gadgetSpecResult = JiraGadgetPermissionManager.this.getPluginGadgetSpec(gadgetState.getGadgetSpecUri());
                        return !gadgetSpecResult.isDefined() || !Vote.DENY.equals((Object)JiraGadgetPermissionManager.this.voteOn((PluginGadgetSpec)gadgetSpecResult.get(), remoteUser));
                    }

                    public Boolean visit(LocalDashboardItemState localDashboardItemState) {
                        return true;
                    }
                });
            }
        };
        return Iterables.transform((Iterable)dashboardState.getDashboardColumns().getColumns(), (Function)new Function<Iterable<DashboardItemState>, Iterable<DashboardItemState>>((Predicate)isUserAbleToSeeDashboardItem){
            final /* synthetic */ Predicate val$isUserAbleToSeeDashboardItem;
            {
                this.val$isUserAbleToSeeDashboardItem = predicate;
            }

            public Iterable<DashboardItemState> apply(Iterable<DashboardItemState> states) {
                return Iterables.filter(states, (Predicate)this.val$isUserAbleToSeeDashboardItem);
            }
        });
    }
}

