/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

class RemoteAddressEntity {
    static final String ENTITY = "RemoteAddress";
    static final String APPLICATION_ID = "applicationId";
    static final String ADDRESS = "address";

    private RemoteAddressEntity() {
    }

    static Map<String, Object> getData(Long applicationId, String remoteAddress) {
        return PrimitiveMap.builder().put(APPLICATION_ID, applicationId).put(ADDRESS, remoteAddress).build();
    }

    static Set<RemoteAddress> toRemoteAddresses(List<GenericValue> remoteAddresses) {
        if (remoteAddresses == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder addresses = ImmutableSet.builder();
        for (GenericValue remoteAddressGv : remoteAddresses) {
            addresses.add((Object)new RemoteAddress(remoteAddressGv.getString(ADDRESS)));
        }
        return addresses.build();
    }
}

