/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

class OfBizUser
implements TimestampedUser,
UserOrGroupStub,
Serializable {
    private static final long serialVersionUID = -3085079271696312159L;
    static final List<String> SUPPORTED_FIELDS = ImmutableList.builder().add((Object)"active").add((Object)"createdDate").add((Object)"directoryId").add((Object)"displayName").add((Object)"emailAddress").add((Object)"externalId").add((Object)"firstName").add((Object)"lastName").add((Object)"updatedDate").add((Object)"id").add((Object)"userName").build();
    private final long id;
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final Date createdDate;
    private final Date updatedDate;
    private final String emailAddress;
    private final String firstName;
    private final String lastName;
    private final String displayName;
    private final String externalId;
    private String lowerUserName;
    private int hash;

    static OfBizUser from(GenericValue userGenericValue) {
        return new OfBizUser(userGenericValue);
    }

    private OfBizUser(GenericValue userGenericValue) {
        Assertions.notNull((String)"userGenericValue", (Object)userGenericValue);
        this.id = userGenericValue.getLong("id");
        this.directoryId = userGenericValue.getLong("directoryId");
        this.name = userGenericValue.getString("userName");
        this.active = BooleanUtils.toBoolean((int)userGenericValue.getInteger("active"));
        this.createdDate = userGenericValue.getTimestamp("createdDate");
        this.updatedDate = userGenericValue.getTimestamp("updatedDate");
        this.emailAddress = this.getEmailAddressFrom(userGenericValue);
        this.firstName = userGenericValue.getString("firstName");
        this.lastName = userGenericValue.getString("lastName");
        this.displayName = userGenericValue.getString("displayName");
        this.externalId = userGenericValue.getString("externalId");
    }

    private String getEmailAddressFrom(GenericValue userGenericValue) {
        String email = userGenericValue.getString("emailAddress");
        return email != null ? email : "";
    }

    @Override
    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLowerName() {
        String lower = this.lowerUserName;
        if (lower == null) {
            this.lowerUserName = lower = IdentifierUtils.toLowerCase((String)this.name);
        }
        return lower;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String toString() {
        return this.name + ':' + this.directoryId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OfBizUser) {
            return this.equalsOfBizUser((OfBizUser)o);
        }
        return o instanceof ApplicationUser && this.equalsUser((ApplicationUser)o);
    }

    private boolean equalsOfBizUser(@Nonnull OfBizUser other) {
        return this.directoryId == other.directoryId && this.hashCode() == other.hashCode() && this.getLowerName().equals(other.getLowerName());
    }

    private boolean equalsUser(@Nonnull ApplicationUser other) {
        return this.directoryId == other.getDirectoryId() && this.getLowerName().equals(IdentifierUtils.toLowerCase((String)other.getName()));
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = UserComparator.hashCode((User)this);
        }
        return h;
    }

    public int compareTo(User other) {
        int nameCompare = this.getLowerName().compareTo(OfBizUser.getLowerName(other));
        if (nameCompare != 0) {
            return nameCompare;
        }
        long directoryId1 = this.directoryId;
        long directoryId2 = other.getDirectoryId();
        return directoryId1 == directoryId2 ? 0 : (directoryId1 < directoryId2 ? -1 : 1);
    }

    @Nonnull
    private static String getLowerName(@Nonnull User user) {
        if (user instanceof OfBizUser) {
            return ((OfBizUser)user).getLowerName();
        }
        return IdentifierUtils.toLowerCase((String)user.getName());
    }
}

