/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.impl.ImmutableAttributes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

class OfBizAttributesBuilder {
    static final String NAME = "name";
    static final String VALUE = "value";
    static final List<String> SUPPORTED_FIELDS = ImmutableList.of((Object)"name", (Object)"value");

    OfBizAttributesBuilder() {
    }

    static Attributes toAttributes(List<GenericValue> attributes) {
        if (attributes == null) {
            return new ImmutableAttributes();
        }
        HashMap attributesMap = Maps.newHashMapWithExpectedSize((int)attributes.size());
        for (GenericValue attribute : attributes) {
            OfBizAttributesBuilder.addAttribute(attributesMap, attribute);
        }
        return new ImmutableAttributes((Map)attributesMap);
    }

    private static void addAttribute(Map<String, Set<String>> attributesMap, GenericValue attributeGv) {
        String value;
        String name = attributeGv.getString(NAME);
        HashSet values = attributesMap.get(name);
        if (values == null) {
            values = Sets.newHashSet();
            attributesMap.put(name, values);
        }
        values.add((value = attributeGv.getString(VALUE)) == null ? "" : value);
    }
}

