/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.managedconfiguration;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemBuilder;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemStore;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagedConfigurationItemService
implements ManagedConfigurationItemService {
    private static final Logger log = LoggerFactory.getLogger(DefaultManagedConfigurationItemService.class);
    private final ManagedConfigurationItemStore managedConfigurationItemStore;
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;

    public DefaultManagedConfigurationItemService(ManagedConfigurationItemStore managedConfigurationItemStore, PermissionManager permissionManager, PluginAccessor pluginAccessor) {
        this.managedConfigurationItemStore = managedConfigurationItemStore;
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public ServiceOutcome<ManagedConfigurationItem> updateManagedConfigurationItem(@Nonnull ManagedConfigurationItem item) {
        if (item.isManaged() && StringUtils.isBlank((String)item.getDescriptionI18nKey())) {
            String key = item.getConfigurationItemAccessLevel() == ConfigurationItemAccessLevel.LOCKED ? "admin.managed.configuration.items.generic.description.locked" : "admin.managed.configuration.items.generic.description.managed";
            item = item.newBuilder().setDescriptionI18nKey(key).build();
        }
        return ServiceOutcomeImpl.ok(this.managedConfigurationItemStore.updateManagedConfigurationItem(item));
    }

    @Nonnull
    public ServiceOutcome<Void> removeManagedConfigurationItem(@Nonnull ManagedConfigurationItem item) {
        boolean success = this.managedConfigurationItemStore.deleteManagedConfigurationItem(item);
        if (success) {
            return ServiceOutcomeImpl.ok(null);
        }
        return ServiceOutcomeImpl.error("admin.managed.configuration.items.error.delete");
    }

    @Nonnull
    public Collection<ManagedConfigurationItem> getManagedConfigurationItems(@Nonnull ManagedConfigurationItemType type) {
        Collection<ManagedConfigurationItem> managedConfigurationItems = this.managedConfigurationItemStore.getManagedConfigurationItems(type);
        return CollectionUtil.transform(managedConfigurationItems, (Function)new Function<ManagedConfigurationItem, ManagedConfigurationItem>(){

            public ManagedConfigurationItem get(ManagedConfigurationItem input) {
                return DefaultManagedConfigurationItemService.this.ensureManagedConfigurationEntitySourceAvailable(input);
            }
        });
    }

    @Nonnull
    public ManagedConfigurationItem getManagedCustomField(@Nonnull CustomField customField) {
        return this.getManagedConfigurationEntity(customField.getId(), ManagedConfigurationItemType.CUSTOM_FIELD);
    }

    @Nonnull
    public ManagedConfigurationItem getManagedWorkflow(@Nonnull JiraWorkflow workflow) {
        return this.getManagedConfigurationEntity(workflow.getName(), ManagedConfigurationItemType.WORKFLOW);
    }

    @Nonnull
    public ManagedConfigurationItem getManagedWorkflowScheme(@Nonnull WorkflowScheme workflowScheme) {
        return this.getManagedWorkflowScheme(workflowScheme.getId());
    }

    @Nonnull
    public ManagedConfigurationItem getManagedWorkflowScheme(@Nonnull Long schemeId) {
        return this.getManagedConfigurationEntity(schemeId.toString(), ManagedConfigurationItemType.WORKFLOW_SCHEME);
    }

    public boolean doesUserHavePermission(ApplicationUser user, @Nonnull ManagedConfigurationItem item) {
        Assertions.notNull((String)"item", (Object)item);
        if (user == null) {
            return false;
        }
        if (!item.isManaged()) {
            return true;
        }
        return this.doesUserHavePermission(user, item.getConfigurationItemAccessLevel());
    }

    public boolean doesUserHavePermission(ApplicationUser user, @Nonnull ConfigurationItemAccessLevel configurationItemAccessLevel) {
        switch (configurationItemAccessLevel) {
            case LOCKED: {
                return false;
            }
            case SYS_ADMIN: {
                return this.permissionManager.hasPermission(44, user);
            }
            case ADMIN: {
                return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(44, user);
            }
        }
        return false;
    }

    private ManagedConfigurationItem getManagedConfigurationEntity(@Nonnull String itemId, @Nonnull ManagedConfigurationItemType itemType) {
        ManagedConfigurationItem managedConfigurationItem = this.managedConfigurationItemStore.getManagedConfigurationItem(itemId, itemType);
        if (managedConfigurationItem != null) {
            return this.ensureManagedConfigurationEntitySourceAvailable(managedConfigurationItem);
        }
        return new ManagedConfigurationItemBuilder().setItemId(itemId).setItemType(itemType).setManaged(false).setConfigurationItemAccessLevel(ConfigurationItemAccessLevel.ADMIN).build();
    }

    private ManagedConfigurationItem ensureManagedConfigurationEntitySourceAvailable(ManagedConfigurationItem managedConfigurationItem) {
        String sourceId = managedConfigurationItem.getSourceId();
        if (StringUtils.isBlank((String)sourceId)) {
            return managedConfigurationItem;
        }
        if (sourceId.startsWith("plugin:") && !this.isPluginEnabled(sourceId = sourceId.substring("plugin:".length()))) {
            managedConfigurationItem = managedConfigurationItem.newBuilder().setManaged(false).setConfigurationItemAccessLevel(ConfigurationItemAccessLevel.ADMIN).build();
        }
        return managedConfigurationItem;
    }

    private boolean isPluginEnabled(String pluginKey) {
        return this.pluginAccessor.isPluginEnabled(pluginKey);
    }
}

