/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.concurrent;

import com.atlassian.jira.concurrent.Barrier;
import com.atlassian.jira.util.concurrent.BlockingCounter;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BarrierImpl
implements Barrier {
    private static final Logger log = LoggerFactory.getLogger(BarrierImpl.class);
    private final String name;
    @VisibleForTesting
    final BlockingCounter counter = new BlockingCounter();
    private final BlockingCounter airlockExit = new BlockingCounter();

    public BarrierImpl(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void await() {
        if (this.counter.wouldBlock()) {
            log.debug("Barrier '{}' is up. Waiting for it to be lowered", (Object)this.name());
            this.counter.awaitUninterruptibly();
            this.airlockExit.awaitUninterruptibly();
        }
        log.debug("Barrier '{}' is down", (Object)this.name());
    }

    @Override
    public void raise() {
        log.debug("Raising barrier '{}'", (Object)this.name());
        this.counter.up();
    }

    @Override
    public void lower() {
        log.debug("Lowering barrier '{}'", (Object)this.name());
        this.counter.down();
    }

    @Override
    public void lowerThenRaise() {
        log.debug("Lowering barrier '{}' for waiting threads, then raising again", (Object)this.name());
        this.airlockExit.up();
        this.counter.down();
        this.waitForZeroWaitingThreads();
        this.counter.up();
        this.airlockExit.down();
    }

    private void waitForZeroWaitingThreads() {
        int timeoutInSeconds = 2;
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        boolean deadlineReached = false;
        while (!deadlineReached && this.counter.getWaitingThreadCount() > 0) {
            deadlineReached = System.currentTimeMillis() > deadline;
        }
        if (deadlineReached) {
            log.warn("Timed out after 2 seconds waiting for threads to move past the barrier. Continuing.");
        }
    }
}

