/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bean;

import com.atlassian.jira.bean.SubTask;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import org.ofbiz.core.entity.GenericValue;

public class SubTaskImpl
implements SubTask {
    private Long sequence;
    private Issue subTaskIssue;
    private Issue parentIssue;

    public SubTaskImpl(Long sequence, Issue subTaskIssue, Issue parentIssue) {
        this.sequence = sequence;
        this.subTaskIssue = subTaskIssue;
        this.parentIssue = parentIssue;
    }

    public SubTaskImpl(Long sequence, GenericValue subTaskIssue, GenericValue parentIssue) {
        this.sequence = sequence;
        this.subTaskIssue = this.getIssueObjectFor(subTaskIssue);
        this.parentIssue = this.getIssueObjectFor(parentIssue);
    }

    public Long getSequence() {
        return this.sequence;
    }

    public Long getDisplaySequence() {
        return this.getSequence() + 1L;
    }

    public Issue getParent() {
        return this.parentIssue;
    }

    public Issue getSubTask() {
        return this.subTaskIssue;
    }

    private Issue getIssueObjectFor(GenericValue issueGV) {
        return ComponentAccessor.getIssueFactory().getIssue(issueGV);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubTaskImpl)) {
            return false;
        }
        SubTaskImpl subTask = (SubTaskImpl)o;
        if (this.parentIssue != null ? !this.parentIssue.equals((Object)subTask.parentIssue) : subTask.parentIssue != null) {
            return false;
        }
        if (this.sequence != null ? !this.sequence.equals(subTask.sequence) : subTask.sequence != null) {
            return false;
        }
        return !(this.subTaskIssue != null ? !this.subTaskIssue.equals((Object)subTask.subTaskIssue) : subTask.subTaskIssue != null);
    }

    public int hashCode() {
        int result = this.sequence != null ? this.sequence.hashCode() : 0;
        result = 29 * result + (this.subTaskIssue != null ? this.subTaskIssue.hashCode() : 0);
        result = 29 * result + (this.parentIssue != null ? this.parentIssue.hashCode() : 0);
        return result;
    }
}

