/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.install.ApplicationInstallationEnvironment;
import com.atlassian.jira.application.install.ApplicationSource;
import com.atlassian.jira.application.install.BundlesVersionDiscovery;
import com.atlassian.jira.application.install.ReversibleFileOperations;
import com.atlassian.jira.application.install.WhatWasInstalledInApplication;
import com.atlassian.jira.application.install.WhatWasInstalledInApplicationFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;

@Nonnull
public class WhatWasInstalled {
    @VisibleForTesting
    static final String APP_INSTALL_INFO_FILE_BASE = "%s.properties";
    private final BundlesVersionDiscovery bundlesVersionDiscovery;
    private final ApplicationInstallationEnvironment applicationInstallationEnvironment;
    private final WhatWasInstalledInApplicationFactory whatWasInstalledInApplicationFactory;

    public WhatWasInstalled(ApplicationInstallationEnvironment applicationInstallationEnvironment, BundlesVersionDiscovery bundlesVersionDiscovery, WhatWasInstalledInApplicationFactory whatWasInstalledInApplicationFactory) {
        this.bundlesVersionDiscovery = bundlesVersionDiscovery;
        this.applicationInstallationEnvironment = applicationInstallationEnvironment;
        this.whatWasInstalledInApplicationFactory = whatWasInstalledInApplicationFactory;
    }

    public boolean wasApplicationSourceInstalled(ApplicationSource applicationSource) throws IOException {
        File applicationConfigFile = this.getApplicationInstallInfoFile(applicationSource.getApplicationSourceName());
        WhatWasInstalledInApplication whatWasInstalledInApplication = this.whatWasInstalledInApplicationFactory.load(applicationConfigFile);
        Collection<BundlesVersionDiscovery.PluginIdentification> pluginIdentifications = this.mapBundlesToVersion(applicationSource.getApplicationBundles());
        return whatWasInstalledInApplication.wereBundlesInstalled(pluginIdentifications);
    }

    public void storeInstalledApplicationSource(ApplicationSource applicationSource, ReversibleFileOperations reversibleFileOperations) throws IOException {
        Collection<BundlesVersionDiscovery.PluginIdentification> pluginIdentifications = this.mapBundlesToVersion(applicationSource.getApplicationBundles());
        WhatWasInstalledInApplication whatWasInstalledInApplication = this.whatWasInstalledInApplicationFactory.load(pluginIdentifications);
        this.whatWasInstalledInApplicationFactory.store(this.getApplicationInstallInfoFile(applicationSource.getApplicationSourceName()), whatWasInstalledInApplication, reversibleFileOperations);
    }

    private File getApplicationInstallInfoFile(String applicationName) {
        File configRoot = this.applicationInstallationEnvironment.getInstallInformationDir();
        return new File(configRoot, String.format(APP_INSTALL_INFO_FILE_BASE, applicationName));
    }

    private Collection<BundlesVersionDiscovery.PluginIdentification> mapBundlesToVersion(File[] sourceBundles) {
        return (Collection)Arrays.stream(sourceBundles).map(this.bundlesVersionDiscovery::getBundleNameAndVersion).collect(CollectorsUtil.toImmutableListWithCapacity((int)sourceBundles.length));
    }
}

