/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.application.host.AbstractApplicationManager;
import com.atlassian.application.host.ApplicationAccessFactory;
import com.atlassian.application.host.i18n.I18nResolver;
import com.atlassian.application.host.license.LicenseLocator;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.DefaultApplicationRoleDefinitions;
import com.atlassian.jira.application.JiraI18nResolver;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import java.net.URI;
import org.joda.time.DateTime;

public class JiraApplicationManager
extends AbstractApplicationManager {
    private final PlatformApplication platformApplication;

    public JiraApplicationManager(PluginApplicationMetaDataManager pluginApplications, BuildUtilsInfo info, JiraAuthenticationContext ctx, LicenseLocator locator, ApplicationAccessFactory accessFactory) {
        super(pluginApplications, (I18nResolver)new JiraI18nResolver(ctx), locator, accessFactory);
        this.platformApplication = new JiraCoreApplication(ctx, locator, accessFactory, info);
    }

    public PlatformApplication getPlatform() {
        return this.platformApplication;
    }

    private static class JiraCoreApplication
    implements PlatformApplication {
        private final JiraAuthenticationContext ctx;
        private final LicenseLocator locator;
        private final ApplicationAccessFactory accessFactory;
        private final BuildUtilsInfo info;

        private JiraCoreApplication(JiraAuthenticationContext ctx, LicenseLocator locator, ApplicationAccessFactory accessFactory, BuildUtilsInfo info) {
            this.info = (BuildUtilsInfo)Assertions.notNull((String)"info", (Object)info);
            this.ctx = (JiraAuthenticationContext)Assertions.notNull((String)"ctx", (Object)ctx);
            this.locator = (LicenseLocator)Assertions.notNull((String)"locator", (Object)locator);
            this.accessFactory = (ApplicationAccessFactory)Assertions.notNull((String)"accessFactory", (Object)accessFactory);
        }

        public ApplicationKey getKey() {
            return DefaultApplicationRoleDefinitions.CoreRoleDefinition.INSTANCE.key();
        }

        public String getName() {
            return DefaultApplicationRoleDefinitions.CoreRoleDefinition.INSTANCE.name();
        }

        public String getDescription() {
            return this.ctx.getI18nHelper().getText("jira.core.description");
        }

        public String getVersion() {
            return this.info.getVersion();
        }

        public String getUserCountDescription(Option<Integer> count) {
            return this.ctx.getI18nHelper().getText("jira.core.user.count", count.getOrElse((Object)-1));
        }

        public Option<URI> getConfigurationURI() {
            return Option.none();
        }

        public Option<URI> getPostInstallURI() {
            return Option.none();
        }

        public Option<URI> getPostUpdateURI() {
            return Option.none();
        }

        public String getDefaultGroup() {
            return "jira-core-users";
        }

        public DateTime buildDate() {
            return new DateTime((Object)this.info.getCurrentBuildDate());
        }

        public Option<SingleProductLicenseDetailsView> getLicense() {
            return (Option)this.locator.apply((Object)this.getKey());
        }

        public ApplicationAccess getAccess() {
            return this.accessFactory.access(this.getKey(), this.buildDate());
        }
    }
}

