/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.action.admin.export.EscapedAttributes;
import com.atlassian.jira.bc.dataimport.EntityImportExportExclusions;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.imports.project.util.XMLEscapeUtil;
import com.atlassian.jira.model.querydsl.UpgradeHistoryDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OfbizImportHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(OfbizImportHandler.class);
    static final String OSPROPERTY_STRING = "OSPropertyString";
    static final String OSPROPERTY_TEXT = "OSPropertyText";
    static final String OSPROPERTY_ENTRY = "OSPropertyEntry";
    static final String OSPROPERTY_NUMBER = "OSPropertyNumber";
    private static final String ENTITY_ENGINE_XML = "entity-engine-xml";
    private static final String SQL_STATE_DEADLOCK = "40001";
    private static final int MAX_SQL_DEADLOCK_RETRIES = 5;
    private static final int INITIAL_STRING_BUILDER_BUFFER_SIZE = 16384;
    private static final int MAX_STRING_BUILDER_SIZE_TO_REUSE = 0x1000000;
    public static final SecureXmlEntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();
    private final OfBizDelegator ofBizDelegator;
    private final Executor executor;
    private TaskProgressSink taskProgressSink = TaskProgressSink.NULL_SINK;
    private final IndexPathManager indexPathManager;
    private final AttachmentPathManager attachmentPathManager;
    private final Map<String, String> osPropertyStringMap = new HashMap<String, String>();
    private final Map<String, String> osPropertyTextMap = new HashMap<String, String>();
    private final Map<String, String> osPropertyNumberMap = new HashMap<String, String>();
    private final AtomicReference<Throwable> importError = new AtomicReference();
    private final List<String> licenseStrings = new ArrayList<String>();
    private final Map<String, String> licenseIds = new HashMap<String, String>();
    private StringBuilder textBuffer = new StringBuilder(16384);
    private boolean hasText = false;
    private boolean hasRootElement = false;
    private List<GenericValue> valueBatch = null;
    private ErrorCollection errorCollection;
    private String inEntity = null;
    private GenericValue value;
    private boolean createEntities;
    private boolean useDefaultIndexPath;
    private boolean useDefaultAttachmentPath;
    private long entityCount;
    private String buildNumberId = null;
    private String buildNumber = null;
    private String indexPath;
    private String indexPathId;
    private String attachmentPath;
    private String attachmentPathId;
    private String indexDefaultId;
    private String attachmentDefaultId;
    private boolean useDefaultPaths;
    private String versionId;
    private String version;
    private String minimumDowngradeVersionId;
    private String minimumDowngradeVersion;
    private Option<String> exportDate;
    private List<UpgradeHistoryDTO> upgradeHistoryItems = new LinkedList<UpgradeHistoryDTO>();

    OfbizImportHandler(OfBizDelegator ofBizDelegator, Executor executor, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager) {
        this(ofBizDelegator, executor, indexPathManager, attachmentPathManager, false);
    }

    public OfbizImportHandler(OfBizDelegator ofBizDelegator, Executor executor, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager, boolean useDefaultPaths) {
        this.ofBizDelegator = ofBizDelegator;
        this.executor = executor;
        this.indexPathManager = indexPathManager;
        this.attachmentPathManager = attachmentPathManager;
        this.createEntities = false;
        this.useDefaultPaths = useDefaultPaths;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return EMPTY_ENTITY_RESOLVER.resolveEntity(publicId, systemId);
    }

    @Override
    public void startDocument() throws SAXException {
        log.debug("Starting Document");
        this.entityCount = 0L;
        this.errorCollection = new SimpleErrorCollection();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.hasRootElement) {
            throw new SAXException("XML file ended too early.  There was no </entity-engine-xml> tag.");
        }
        this.createBuildNumber();
        this.createVersionString();
        this.createMinimumDowngradeVersionString();
        this.createLicenseString();
        this.createIndexDefault();
        this.createAttachmentDefault();
        this.createIndexPath();
        this.createAttachmentPath();
        log.debug("Ending Document");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.importError.get() != null) {
            throw new SAXException(new Exception(this.importError.get()));
        }
        if (this.hasRootElement) {
            if (this.inEntity != null) {
                if (!EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT.contains(this.inEntity)) {
                    if (this.value == null) {
                        throw new SAXException("Somehow we have got inside an Entity without creating a GenericValue for it.");
                    }
                    log.debug("Read opening subelement {} of entity {}", (Object)qName, (Object)this.value.getEntityName());
                    this.resetTextBuffer();
                }
            } else {
                log.debug("Read opening {} element", (Object)qName);
                EscapedAttributes decodedAttributes = new EscapedAttributes(attributes);
                this.inEntity = qName;
                this.value = this.createEntities ? this.parseValue(qName, decodedAttributes) : this.parseValueFailsafe(qName, decodedAttributes);
                this.recordElementsInfo(qName, decodedAttributes);
                this.recordLicenseInfo(qName, this.value);
                this.recordUpgradeHistory(qName, this.value);
                if (this.isPropertyString(qName)) {
                    this.setDefaultPaths(decodedAttributes);
                }
                if (this.isPropertyNumber(qName)) {
                    this.setUseDefaultPaths(decodedAttributes);
                }
            }
        } else if (ENTITY_ENGINE_XML.equals(qName)) {
            log.debug("Read opening ROOT element");
            this.hasRootElement = true;
            this.valueBatch = new ArrayList<GenericValue>();
            String date = attributes.getValue("date");
            this.exportDate = Option.option((Object)date);
        } else {
            throw new SAXException("The XML document does not contain the <entity-engine-xml> root element or it was closed too early.");
        }
    }

    private void recordLicenseInfo(String qName, GenericValue value) {
        if (!qName.equals("ProductLicense")) {
            return;
        }
        String license = value.getString("license");
        if (license != null) {
            this.licenseStrings.add(license);
        }
    }

    private void recordUpgradeHistory(String qName, GenericValue gv) {
        if (qName.equals("UpgradeHistory")) {
            this.upgradeHistoryItems.add(UpgradeHistoryDTO.fromGenericValue(gv));
        }
    }

    private GenericValue parseValueFailsafe(String qName, Attributes decodedAttributes) {
        try {
            return this.parseValue(qName, decodedAttributes);
        }
        catch (RuntimeException e) {
            if (log.isInfoEnabled()) {
                log.info("Failed to parse value for element " + qName + ".", (Throwable)e);
            }
            if (!this.errorCollection.hasAnyErrors()) {
                this.errorCollection.addErrorMessage(e.getMessage());
            }
            return new GenericValue(new ModelEntity());
        }
    }

    private GenericValue parseValue(String qName, Attributes decodedAttributes) {
        GenericValue genericValue = this.ofBizDelegator.makeValue(qName);
        ModelEntity modelEntity = genericValue.getModelEntity();
        if (EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT.contains(modelEntity.getEntityName())) {
            return null;
        }
        Iterator i = modelEntity.getFieldsIterator();
        while (i.hasNext()) {
            ModelField modelField = (ModelField)i.next();
            String name = modelField.getName();
            String attr = decodedAttributes.getValue(name);
            if (attr == null) continue;
            try {
                log.debug("Setting attribute {} with value {}", (Object)name, (Object)attr);
                genericValue.setString(name, attr);
            }
            catch (RuntimeException e) {
                log.error("Failed to set attribute '" + qName + "." + name + "' with value '" + attr + "'. Error: " + e.getMessage());
                throw e;
            }
        }
        return genericValue;
    }

    private void setDefaultPaths(Attributes attributes) {
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.indexPathId)) {
            this.value.setString("value", this.indexPathManager.getDefaultIndexRootPath());
        }
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.attachmentPathId)) {
            this.value.setString("value", this.attachmentPathManager.getDefaultAttachmentPath());
        }
    }

    private void setUseDefaultPaths(Attributes attributes) {
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.indexDefaultId)) {
            this.value.setString("value", "1");
        }
        if (this.useDefaultPaths && attributes.getValue("id").equals(this.attachmentDefaultId)) {
            this.value.setString("value", "1");
        }
    }

    void createBuildNumber() {
        if (this.buildNumberId != null) {
            this.buildNumber = this.osPropertyStringMap.get(this.buildNumberId);
        }
    }

    private void createVersionString() {
        if (this.versionId != null) {
            this.version = this.osPropertyStringMap.get(this.versionId);
        }
    }

    private void createMinimumDowngradeVersionString() {
        if (this.minimumDowngradeVersionId != null) {
            this.minimumDowngradeVersion = this.osPropertyStringMap.get(this.minimumDowngradeVersionId);
        }
    }

    private void createAttachmentDefault() {
        if (this.useDefaultPaths) {
            this.useDefaultAttachmentPath = true;
        } else if (this.attachmentDefaultId != null) {
            this.useDefaultAttachmentPath = "1".equals(this.osPropertyNumberMap.get(this.attachmentDefaultId));
        }
    }

    private void createIndexDefault() {
        if (this.useDefaultPaths) {
            this.useDefaultIndexPath = true;
        } else if (this.indexDefaultId != null) {
            this.useDefaultIndexPath = "1".equals(this.osPropertyNumberMap.get(this.indexDefaultId));
        }
    }

    void createIndexPath() {
        if (this.useDefaultIndexPath) {
            this.indexPath = this.indexPathManager.getDefaultIndexRootPath();
        } else if (this.indexPathId != null) {
            this.indexPath = this.osPropertyStringMap.get(this.indexPathId);
        }
    }

    void createAttachmentPath() {
        if (this.useDefaultAttachmentPath) {
            this.attachmentPath = this.attachmentPathManager.getDefaultAttachmentPath();
        } else if (this.attachmentPathId != null) {
            this.attachmentPath = this.osPropertyStringMap.get(this.attachmentPathId);
        }
    }

    void createLicenseString() {
        String license = this.osPropertyTextMap.get(this.licenseIds.get("License20"));
        if (license != null) {
            this.licenseStrings.add(license);
        }
    }

    void recordElementsInfo(String qName, Attributes attributes) {
        this.recordProperties(qName, attributes, OSPROPERTY_STRING, this.osPropertyStringMap);
        this.recordProperties(qName, attributes, OSPROPERTY_TEXT, this.osPropertyTextMap);
        this.recordProperties(qName, attributes, OSPROPERTY_NUMBER, this.osPropertyNumberMap);
        if (this.isPropertyEntry(qName, attributes, "jira.version.patched")) {
            this.buildNumberId = attributes.getValue("id");
        }
        if (this.isPropertyEntry(qName, attributes, "jira.version")) {
            this.versionId = attributes.getValue("id");
        }
        if (this.isPropertyEntry(qName, attributes, "jira.downgrade.minimum.version")) {
            this.minimumDowngradeVersionId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "License20")) {
            this.licenseIds.put("License20", attributes.getValue("id"));
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.index")) {
            this.indexPathId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.index.use.default.directory")) {
            this.indexDefaultId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.attachments")) {
            this.attachmentPathId = attributes.getValue("id");
        } else if (this.isPropertyEntry(qName, attributes, "jira.path.attachments.use.default.directory")) {
            this.attachmentDefaultId = attributes.getValue("id");
        }
    }

    private void recordProperties(String qName, Attributes attributes, String entityName, Map<String, String> store) {
        if (entityName.equals(qName)) {
            String id = attributes.getValue("id");
            String value = attributes.getValue("value");
            if (id != null && value != null) {
                store.put(id, value);
            }
        }
    }

    private boolean isPropertyEntry(String qName, Attributes attributes, String property) {
        return StringUtils.equals((String)OSPROPERTY_ENTRY, (String)qName) && StringUtils.equals((String)property, (String)attributes.getValue("propertyKey")) && StringUtils.isNotBlank((String)attributes.getValue("id"));
    }

    private boolean isPropertyString(String qName) {
        return StringUtils.equals((String)OSPROPERTY_STRING, (String)qName);
    }

    private boolean isPropertyNumber(String qName) {
        return StringUtils.equals((String)OSPROPERTY_NUMBER, (String)qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.hasRootElement) {
            if (ENTITY_ENGINE_XML.equals(qName)) {
                if (this.createEntities) {
                    this.createValue(this.valueBatch);
                    this.valueBatch = new ArrayList<GenericValue>();
                }
                log.debug("Read closing ROOT element");
                this.hasRootElement = false;
            } else {
                if (this.inEntity == null) {
                    throw new SAXException("There is no entity set");
                }
                if (this.inEntity.equals(qName)) {
                    log.debug("Read closing " + qName + " element");
                    ++this.entityCount;
                    if (this.createEntities) {
                        if (this.valueBatch.size() > 64) {
                            this.createValue(this.valueBatch);
                            this.valueBatch = new ArrayList<GenericValue>();
                        }
                        if (this.value != null) {
                            this.valueBatch.add(this.value);
                        }
                        this.taskProgressSink.makeProgress(this.entityCount, "data.import.store.entities", "data.import.store.entities.progress");
                    }
                    this.value = null;
                    this.inEntity = null;
                } else if (!EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT.contains(this.inEntity)) {
                    log.debug("Read closing subelement " + qName + " of entity " + this.value);
                    if (this.hasText) {
                        if (log.isDebugEnabled()) {
                            log.debug("Setting attribute " + qName + " with value " + this.textBuffer.toString());
                        }
                        this.value.setString(qName, this.textBuffer.toString());
                    }
                }
                this.resetTextBuffer();
            }
        } else {
            throw new SAXException("How did we get here an exception should already have been thrown");
        }
    }

    private void createValue(final List<GenericValue> valueBatch) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    OfbizImportHandler.this.createWithDeadlockRetry(valueBatch);
                }
                catch (Error e) {
                    log.error("Exception importing entity: " + e, (Throwable)e);
                    OfbizImportHandler.this.importError.set(e);
                    throw e;
                }
                catch (Exception e) {
                    log.error("Exception importing entity: " + e, (Throwable)e);
                    OfbizImportHandler.this.importError.set(new DataAccessException((Throwable)e));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWithDeadlockRetry(List<GenericValue> valueBatch) throws GenericEntityException {
        boolean deadlocked;
        int attempts = 0;
        do {
            deadlocked = false;
            boolean begun = CoreTransactionUtil.begin();
            try {
                for (GenericValue genericValue : valueBatch) {
                    genericValue.create();
                }
                CoreTransactionUtil.commit(begun);
                begun = false;
            }
            catch (GenericEntityException e) {
                String sqlState = OfbizImportHandler.getSqlState(e);
                if (++attempts <= 5 && sqlState != null && sqlState.equals(SQL_STATE_DEADLOCK)) {
                    deadlocked = true;
                    continue;
                }
                throw e;
            }
            finally {
                if (begun) {
                    CoreTransactionUtil.rollback(begun);
                }
                if (deadlocked) {
                    try {
                        Thread.sleep((int)(Math.random() * 100.0) + attempts * 100);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } while (deadlocked);
    }

    private static String getSqlState(GenericEntityException e) {
        Throwable ex = e.getNested();
        while (ex != null) {
            if (ex instanceof SQLException) {
                return ((SQLException)ex).getSQLState();
            }
            if (ex instanceof GenericEntityException) {
                ex = ((GenericEntityException)ex).getNested();
                continue;
            }
            ex = null;
        }
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = XMLEscapeUtil.unicodeDecode(new String(ch, start, length));
        this.textBuffer.append(s);
        this.hasText = true;
    }

    private void resetTextBuffer() {
        if (this.textBuffer.length() > 0x1000000) {
            this.textBuffer = new StringBuilder(16384);
        } else {
            this.textBuffer.setLength(0);
        }
        this.hasText = false;
    }

    public void setCreateEntities(boolean createEntities) {
        this.createEntities = createEntities;
    }

    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public long getEntityCount() {
        return this.entityCount;
    }

    @Nullable
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Nonnull
    public Iterable<String> getLicenseStrings() {
        return this.licenseStrings;
    }

    public Throwable getImportError() {
        return this.importError.get();
    }

    public boolean isUseDefaultIndexPath() {
        return this.useDefaultIndexPath;
    }

    public boolean isUseDefaultAttachmentPath() {
        return this.useDefaultAttachmentPath;
    }

    @Nullable
    public String getIndexPath() {
        return this.indexPath;
    }

    @Nullable
    public String getAttachmentPath() {
        return this.attachmentPath;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getMinimumDowngradeVersion() {
        return this.minimumDowngradeVersion;
    }

    @Nonnull
    public List<UpgradeHistoryDTO> getUpgradeHistory() {
        return this.upgradeHistoryItems;
    }

    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    public Option<String> getExportDate() {
        return this.exportDate;
    }
}

