/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ehcache.EhCacheManager;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.NoopCacheEventListenerFactory;
import com.atlassian.jira.cache.CacheCompactor;
import com.atlassian.jira.cache.EhCacheCompactor;
import com.atlassian.jira.cache.LongExpireMemoryCacheManager;
import com.atlassian.jira.cache.NullCacheCompactor;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.EhCacheConfigurationFactory;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanServer;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheManagerRegistrar {
    public static final String EHCACHE_CONFIGURATION = "atlassian.ehcache.config";
    public static final String ENABLE_JMX = "atlassian.cache.jmx";
    public static final String FORCE_EHCACHE = "atlassian.cache.ehcache";
    public static final String FORCE_LONG_EXPIRE = "atlassian.cache.long.expire";
    @VisibleForTesting
    static final ComponentContainer.Scope MANAGER_SCOPE = ComponentContainer.Scope.PROVIDED;
    static final ComponentContainer.Scope COMPACTOR_SCOPE = ComponentContainer.Scope.INTERNAL;
    @VisibleForTesting
    static final Class<CacheManager> MANAGER_KEY = CacheManager.class;
    static final Class<CacheCompactor> COMPACTOR_KEY = CacheCompactor.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheManagerRegistrar.class);

    CacheManagerRegistrar() {
    }

    public static void registerCacheManager(ComponentContainer container, MBeanServer mBeanServer) {
        CacheCompactor cacheCompactor;
        LongExpireMemoryCacheManager cacheManager;
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        ClusterNodeProperties clusterNodeProperties = container.getComponentInstance(ClusterNodeProperties.class);
        boolean useEhcache = CacheManagerRegistrar.useEhcache(jiraProperties, clusterNodeProperties);
        boolean useLongExpire = jiraProperties.getBoolean(FORCE_LONG_EXPIRE);
        LOGGER.debug("Using Ehcache = {}", (Object)useEhcache);
        if (useEhcache) {
            net.sf.ehcache.CacheManager delegate = CacheManagerRegistrar.getCacheManagerDelegate(container, jiraProperties, clusterNodeProperties);
            cacheManager = new EhCacheManager(delegate, null);
            cacheCompactor = new EhCacheCompactor(delegate);
        } else if (useLongExpire) {
            cacheManager = new LongExpireMemoryCacheManager();
            cacheCompactor = new NullCacheCompactor();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("LongExpireMemoryCacheManager was enabled");
            }
        } else {
            cacheManager = new MemoryCacheManager();
            cacheCompactor = new NullCacheCompactor();
        }
        CacheManagerRegistrar.enableJmxIfNecessary(jiraProperties, (CacheManager)cacheManager, mBeanServer);
        container.instance(MANAGER_SCOPE, MANAGER_KEY, cacheManager);
        container.instance(COMPACTOR_SCOPE, COMPACTOR_KEY, cacheCompactor);
    }

    public static void shutDownCacheManager(ComponentContainer container, MBeanServer mBeanServer) {
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        CacheManager cacheManager = container.getComponentInstance(MANAGER_KEY);
        if (jiraProperties.getBoolean(ENABLE_JMX).booleanValue() && cacheManager instanceof MBeanRegistrar) {
            ((MBeanRegistrar)cacheManager).unregisterMBeans(mBeanServer);
        }
        if (cacheManager != null) {
            cacheManager.shutdown();
        }
    }

    private static net.sf.ehcache.CacheManager getCacheManagerDelegate(ComponentContainer container, JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        URL configUrl = CacheManagerRegistrar.class.getResource("/ehcache.xml");
        String customEhcacheConfig = jiraProperties.getProperty(EHCACHE_CONFIGURATION);
        if (StringUtils.isNotBlank((CharSequence)customEhcacheConfig)) {
            File customEhcacheConfigFile = new File(customEhcacheConfig);
            if (customEhcacheConfigFile.isFile()) {
                try {
                    configUrl = customEhcacheConfigFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Could not create a URL from " + customEhcacheConfigFile);
                }
            } else {
                LOGGER.error(customEhcacheConfigFile + " is not a file; defaulting to JIRA's built-in Ehcache configuration");
            }
        }
        Configuration config = CacheManagerRegistrar.buildConfiguration(container, configUrl, clusterNodeProperties);
        return NoopCacheEventListenerFactory.workAroundCache95(net.sf.ehcache.CacheManager.newInstance((Configuration)config));
    }

    private static Configuration buildConfiguration(ComponentContainer container, URL configUrl, ClusterNodeProperties clusterNodeProperties) {
        EhCacheConfigurationFactory configurationFactory = container.getComponentInstance(EhCacheConfigurationFactory.class);
        return configurationFactory.newConfiguration(configUrl, clusterNodeProperties);
    }

    private static void enableJmxIfNecessary(JiraProperties jiraProperties, CacheManager cacheManager, MBeanServer mBeanServer) {
        if (jiraProperties.getBoolean(ENABLE_JMX).booleanValue() && cacheManager instanceof MBeanRegistrar) {
            ((MBeanRegistrar)cacheManager).registerMBeans(mBeanServer);
        }
    }

    private static boolean useEhcache(JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        boolean isEhCacheForced = jiraProperties.getBoolean(FORCE_EHCACHE);
        boolean isJiraClustered = clusterNodeProperties.getNodeId() != null;
        return isEhCacheForced || isJiraClustered;
    }
}

