/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.velocity.VelocityTypesUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.velocity.util.introspection.MethodMap;

public class JiraMethodMap
extends MethodMap {
    private static final Predicate<Class<?>> IS_PUBLIC_CLASS = new Predicate<Class<?>>(){

        public boolean apply(Class<?> clazz) {
            return Modifier.isPublic(clazz.getModifiers());
        }
    };
    private static final Function<Class<?>, Iterable<Method>> GET_ALL_DECLARED_METHODS = new Function<Class<?>, Iterable<Method>>(){

        public Iterable<Method> apply(Class<?> clazz) {
            return Arrays.asList(clazz.getDeclaredMethods());
        }
    };
    private static final Predicate<? super Method> PUBLIC_METHOD = new Predicate<Method>(){

        public boolean apply(Method method) {
            return Modifier.isPublic(method.getModifiers());
        }
    };
    private static final Function<? super Class<?>, Iterable<Class<?>>> GET_CLASS_AND_ALL_INTERFACES = new Function<Class<?>, Iterable<Class<?>>>(){

        public Iterable<Class<?>> apply(Class<?> clazz) {
            return new ClassAndAllInterfacesIterator(clazz);
        }
    };
    private static final Function<? super MethodComparator, Method> TO_METHOD = new Function<MethodComparator, Method>(){

        public Method apply(MethodComparator methodComparator) {
            return methodComparator.method;
        }
    };
    private static final Function<Method, MethodComparator> TO_METHOD_COMPARATOR = new Function<Method, MethodComparator>(){

        public MethodComparator apply(@Nullable Method method) {
            return new MethodComparator(method);
        }
    };
    private final Class<?> clazz;
    private final LoadingCache<String, List<Method>> methodsCache = CacheBuilder.newBuilder().softValues().weakKeys().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<Method>>(){

        public List<Method> load(@Nonnull String s) throws Exception {
            return ImmutableList.copyOf((Iterable)JiraMethodMap.this.loadMethodsForName(s));
        }
    });

    public JiraMethodMap(Class<?> clazz) {
        this.clazz = clazz;
    }

    public List<Method> get(String methodName) {
        if (methodName == null) {
            return Collections.emptyList();
        }
        return (List)this.methodsCache.getUnchecked((Object)methodName);
    }

    public void add(Method method) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public Method find(String methodName, Object[] args) throws MethodMap.AmbiguousException {
        Preconditions.checkNotNull((Object)args, (Object)"params cannot not be null");
        final Class[] parametersTypes = VelocityTypesUtil.getParametersTypes(args);
        ImmutableList methods = ImmutableList.copyOf((Iterable)Iterables.filter(this.get(methodName), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return Arrays.equals(VelocityTypesUtil.getMethodArgsTypes(method), parametersTypes);
            }
        }));
        if (methods.size() == 1) {
            return (Method)Iterables.getOnlyElement((Iterable)methods);
        }
        if (methods.isEmpty()) {
            return super.find(methodName, args);
        }
        throw new MethodMap.AmbiguousException();
    }

    private Iterable<Method> loadMethodsForName(String methodName) {
        return this.deduplicateByNameAndArgumentTypes(this.publicMethodsWithName(this.allClassesAndInterfaces(), methodName));
    }

    private Iterable<Method> deduplicateByNameAndArgumentTypes(Iterable<Method> methods) {
        return Iterables.transform((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(methods, TO_METHOD_COMPARATOR)).asList(), TO_METHOD);
    }

    private Iterable<Method> publicMethodsWithName(Iterable<Class<?>> classes, String methodName) {
        Iterable allMethods = Iterables.concat((Iterable)Iterables.transform(classes, GET_ALL_DECLARED_METHODS));
        Iterable publicMethods = Iterables.filter((Iterable)allMethods, PUBLIC_METHOD);
        return Iterables.filter((Iterable)publicMethods, (Predicate)new MethodByName(methodName));
    }

    private Iterable<Class<?>> allClassesAndInterfaces() {
        return Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform(this.getSuperClasses(this.clazz), GET_CLASS_AND_ALL_INTERFACES)), IS_PUBLIC_CLASS);
    }

    private Iterable<Class<?>> getSuperClasses(Class<?> clazz) {
        ImmutableList.Builder retBuilder = ImmutableList.builder();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            retBuilder.add(current);
        }
        return retBuilder.build();
    }

    private static class MethodByName
    implements Predicate<Method> {
        private final String methodName;

        public MethodByName(String methodName) {
            this.methodName = methodName;
        }

        public boolean apply(Method method) {
            return method.getName().equals(this.methodName);
        }
    }

    private static class MethodComparator {
        private final Method method;

        private MethodComparator(Method method) {
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodComparator that = (MethodComparator)o;
            if (!this.method.getName().equals(that.method.getName())) {
                return false;
            }
            return Arrays.equals(this.method.getParameterTypes(), that.method.getParameterTypes());
        }

        public int hashCode() {
            int result = this.method.getName().hashCode();
            result = 31 * result + Arrays.hashCode(this.method.getParameterTypes());
            return result;
        }
    }

    private static class ClassAndAllInterfacesIterator
    implements Iterable<Class<?>> {
        private final Class<?> clazz;

        public ClassAndAllInterfacesIterator(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Iterator<Class<?>> iterator() {
            return new Iterator<Class<?>>(){
                private final Queue<Class<?>> interfacesToVisit;
                {
                    this.interfacesToVisit = Lists.newLinkedList(Collections.singleton(clazz));
                }

                @Override
                public boolean hasNext() {
                    return !this.interfacesToVisit.isEmpty();
                }

                @Override
                public Class<?> next() {
                    Class<?> currentInterface = this.interfacesToVisit.remove();
                    this.interfacesToVisit.addAll(Arrays.asList(currentInterface.getInterfaces()));
                    return currentInterface;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }
}

