/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Map;

public class DateFormatProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext authenticationContext;

    public DateFormatProvider(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public Jsonable get() {
        final DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(this.authenticationContext.getLocale());
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    DateFormatProvider.this.getDateFormatsJson(dateFormatSymbols).write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    private JSONObject getDateFormatsJson(DateFormatSymbols dateFormatSymbols) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"meridiem", Arrays.asList(dateFormatSymbols.getAmPmStrings()));
        builder.put((Object)"eras", Arrays.asList(dateFormatSymbols.getEras()));
        builder.put((Object)"months", Arrays.asList(dateFormatSymbols.getMonths()).subList(0, 12));
        builder.put((Object)"monthsShort", Arrays.asList(dateFormatSymbols.getShortMonths()).subList(0, 12));
        builder.put((Object)"weekdaysShort", Arrays.asList(dateFormatSymbols.getShortWeekdays()).subList(1, 8));
        builder.put((Object)"weekdays", Arrays.asList(dateFormatSymbols.getWeekdays()).subList(1, 8));
        return new JSONObject((Map)builder.build());
    }
}

