/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.InvalidAttachmentPathException;
import com.atlassian.jira.web.servlet.ViewAttachmentServlet;
import com.atlassian.seraph.util.RedirectUtils;
import io.atlassian.blobstore.client.api.Unit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewFileServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewAttachmentServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String attachmentQuery;
            try {
                attachmentQuery = this.attachmentQuery(request);
            }
            catch (InvalidAttachmentPathException e) {
                response.sendError(400, "Invalid attachment path");
                return;
            }
            catch (AttachmentNotFoundException nfe) {
                this.send404(request, response);
                return;
            }
            this.streamFileData(request, response, attachmentQuery);
        }
        catch (Exception e) {
            if (WebExceptionChecker.canBeSafelyIgnored(e)) {
                return;
            }
            log.error("Error serving file for path " + request.getPathInfo() + ": " + e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void send404(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404, String.format("Attachment %s was not found", request.getPathInfo()));
    }

    private void redirectForSecurityBreach(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getUserName() != null) {
            RequestDispatcher rd = request.getRequestDispatcher("/secure/views/securitybreach.jsp");
            JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
    }

    private void streamFileData(final HttpServletRequest request, final HttpServletResponse response, String attachmentPath) throws IOException, ServletException {
        try {
            this.getInputStream(attachmentPath, new InputStreamConsumer<Unit>(){

                public Unit withInputStream(InputStream is) throws IOException {
                    AbstractViewFileServlet.this.setResponseHeaders(request, response);
                    ServletOutputStream out = response.getOutputStream();
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)out);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                    return Unit.UNIT;
                }
            });
        }
        catch (AttachmentNotFoundException e) {
            log.error("Error finding " + request.getPathInfo() + " : " + e.getMessage());
            this.send404(request, response);
            return;
        }
        catch (FileNotFoundException e) {
            log.error("Error finding " + request.getPathInfo() + " : " + e.getMessage());
            this.send404(request, response);
            return;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error serving content to client", (Throwable)e);
            }
        }
        catch (PermissionException e) {
            this.redirectForSecurityBreach(request, response);
            return;
        }
    }

    protected final String attachmentQuery(HttpServletRequest request) {
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 1 || pi.indexOf(47, 1) == -1) {
            throw new InvalidAttachmentPathException();
        }
        return pi;
    }

    protected abstract void getInputStream(String var1, InputStreamConsumer<Unit> var2) throws IOException, PermissionException;

    protected abstract void setResponseHeaders(HttpServletRequest var1, HttpServletResponse var2) throws InvalidAttachmentPathException, DataAccessException, IOException;

    protected final String getUserName() {
        ApplicationUser user = this.getJiraAuthenticationContext().getUser();
        return user != null ? user.getUsername() : null;
    }

    protected JiraAuthenticationContext getJiraAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }
}

