/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.debug;

import com.atlassian.jira.web.debug.BreakpointReadyHttpServletResponse;
import java.lang.reflect.Field;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ClearDomainFromCookiesHttpServletResponse
extends BreakpointReadyHttpServletResponse {
    private Field cookieDomainField;

    public ClearDomainFromCookiesHttpServletResponse(HttpServletResponse delegate) {
        super(delegate);
        try {
            this.cookieDomainField = Cookie.class.getDeclaredField("domain");
            this.cookieDomainField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            this.cookieDomainField = null;
        }
    }

    @Override
    public void addCookie(Cookie cookie) {
        try {
            this.cookieDomainField.set(cookie, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.addCookie(cookie);
    }

    @Override
    public void setHeader(String name, String value) {
        super.setHeader(name, this.getCookieValue(name, value));
    }

    @Override
    public void addHeader(String name, String value) {
        super.addHeader(name, this.getCookieValue(name, value));
    }

    private String getCookieValue(String name, String value) {
        if ("Set-Cookie".equals(name) && StringUtils.isNotBlank((CharSequence)value)) {
            return value.replaceFirst("(?i)\\s*Domain=.+?;\\s*", " ");
        }
        return value;
    }
}

