/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.gzipfilter.org.apache.commons.lang.math.NumberUtils;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.comparator.UserNameComparator;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class UserPickerFilter
extends PagerFilter {
    private UserFilter filter;
    private String nameFilter;
    private String emailFilter;
    private String group;
    private final FieldConfigManager fieldConfigManager;
    private final JiraServiceContext jiraServiceContext;
    private final PermissionManager permissionManager;
    private final UserFilterManager userFilterManager;
    private final UserSearchService userSearchService;
    private String element;
    private Long fieldConfigId;
    private Collection<Long> projectIds;

    public UserPickerFilter(FieldConfigManager fieldConfigManager, JiraServiceContext jiraServiceContext, PermissionManager permissionManager, UserFilterManager userFilterManager, UserSearchService userSearchService) {
        this.fieldConfigManager = fieldConfigManager;
        this.jiraServiceContext = jiraServiceContext;
        this.permissionManager = permissionManager;
        this.userFilterManager = userFilterManager;
        this.userSearchService = userSearchService;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.nameFilter = FilterUtils.verifyString(nameFilter);
    }

    public String getEmailFilter() {
        return this.emailFilter;
    }

    public void setEmailFilter(String emailFilter) {
        this.emailFilter = FilterUtils.verifyString(emailFilter);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public Long getFieldConfigId() {
        return this.fieldConfigId;
    }

    public void setFieldConfigId(Long fieldConfigId) {
        this.fieldConfigId = fieldConfigId;
    }

    public Collection<Long> getProjectIds() {
        return this.projectIds;
    }

    public void setProjectId(String[] projectIds) {
        this.projectIds = Sets.newHashSetWithExpectedSize((int)projectIds.length);
        for (String projectIdStr : projectIds) {
            long projectId = NumberUtils.toLong((String)projectIdStr, (long)-1L);
            if (projectId == -1L) continue;
            this.projectIds.add(projectId);
        }
    }

    public List<ApplicationUser> getFilteredUsers() throws Exception {
        UserFilter filter = this.getFilter();
        Collection projectIdSet = CustomFieldUtils.getProjectIdsForUser((ApplicationUser)this.jiraServiceContext.getLoggedInApplicationUser(), this.projectIds, (PermissionManager)this.permissionManager, (UserFilter)filter);
        UserNameComparator userNameComparator = new UserNameComparator(this.jiraServiceContext.getI18nBean().getLocale());
        UserSearchParams userSearchParams = UserSearchParams.builder().allowEmptyQuery(true).canMatchEmail(true).filter(filter).filterByProjectIds(projectIdSet).build();
        List usersByFilter = this.userSearchService.findUsers(this.nameFilter, this.emailFilter, userSearchParams);
        if (this.group == null) {
            return usersByFilter;
        }
        UserFilter filterByGroup = new UserFilter(true, null, (Collection)ImmutableSet.of((Object)this.group));
        UserSearchParams userSearchParamsWithGroup = UserSearchParams.builder().allowEmptyQuery(true).canMatchEmail(true).filter(filterByGroup).build();
        List usersByGroup = this.userSearchService.findUsers(this.nameFilter, this.emailFilter, userSearchParamsWithGroup);
        return this.intersectLists((Comparator<ApplicationUser>)userNameComparator, usersByFilter, usersByGroup);
    }

    @VisibleForTesting
    List<ApplicationUser> intersectLists(Comparator<ApplicationUser> userNameComparator, List<ApplicationUser> list1, List<ApplicationUser> list2) {
        if (list1 == null || list2 == null) {
            return ImmutableList.of();
        }
        TreeSet<ApplicationUser> intersection = new TreeSet<ApplicationUser>(userNameComparator);
        intersection.addAll(list1);
        intersection.retainAll(list2);
        return ImmutableList.copyOf(intersection);
    }

    private UserFilter getFilter() {
        if (this.filter == null) {
            FieldConfig fieldConfig;
            this.filter = this.fieldConfigId == null ? UserFilter.DISABLED : ((fieldConfig = this.fieldConfigManager.getFieldConfig(this.fieldConfigId)) == null ? UserFilter.DISABLED : this.userFilterManager.getFilter(fieldConfig));
        }
        return this.filter;
    }
}

