/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.AdminAccessHelper;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupAdminUserSessionStorage;
import com.atlassian.jira.web.action.setup.SetupLicenseSessionStorage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class SetupAdminAccount
extends AbstractSetupAction {
    String username;
    String fullname;
    String firstname;
    String lastname;
    String email;
    String password;
    String confirm;
    private String EXISTING_ADMINS = "existingadmins";
    private final UserService userService;
    private final GroupManager groupManager;
    private final UserUtil userUtil;
    private final ApplicationManager applicationManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final JiraLicenseService jiraLicenseService;
    private final JiraWebResourceManager webResourceManager;
    private final GlobalPermissionManager globalPermissionManager;
    private UserService.CreateUserValidationResult result;

    public SetupAdminAccount(UserService userService, GroupManager groupManager, UserUtil userUtil, FileFactory fileFactory, ApplicationManager applicationManager, ApplicationRoleManager applicationRoleManager, JiraLicenseService jiraLicenseService, JiraWebResourceManager webResourceManager, JiraProperties jiraProperties, GlobalPermissionManager globalPermissionManager) {
        super(fileFactory, jiraProperties);
        this.userService = userService;
        this.groupManager = groupManager;
        this.userUtil = userUtil;
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.jiraLicenseService = jiraLicenseService;
        this.webResourceManager = webResourceManager;
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((String)"globalPermissionManager", (Object)globalPermissionManager);
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.userUtil.getJiraAdministrators().size() > 0) {
            return this.EXISTING_ADMINS;
        }
        this.prePopulateFields();
        this.putSENIntoMetadata();
        return super.doDefault();
    }

    private void prePopulateFields() {
        SetupLicenseSessionStorage sessionStorage = (SetupLicenseSessionStorage)this.request.getSession().getAttribute(SetupLicenseSessionStorage.SESSION_KEY);
        this.request.getSession().removeAttribute(SetupLicenseSessionStorage.SESSION_KEY);
        if (sessionStorage != null) {
            this.firstname = Strings.nullToEmpty((String)sessionStorage.getFirstName());
            this.lastname = Strings.nullToEmpty((String)sessionStorage.getLastName());
            this.email = Strings.nullToEmpty((String)sessionStorage.getEmail());
            if (Strings.isNullOrEmpty((String)this.fullname)) {
                this.fullname = (this.firstname + " " + this.lastname).trim();
            }
            if (!Strings.isNullOrEmpty((String)this.firstname) && !Strings.isNullOrEmpty((String)this.lastname)) {
                this.username = (this.firstname.charAt(0) + this.lastname).replaceAll("\\s", "").toLowerCase();
            }
        }
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        this.result = this.userService.validateCreateUserForSetup(this.getLoggedInUser(), this.username != null ? this.username.trim() : this.username, this.getPassword(), this.getConfirm(), this.getEmail(), this.getFullname());
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
    }

    protected String doExecute() {
        block10: {
            if (this.setupAlready()) {
                return "setupalready";
            }
            ApplicationUser administrator = null;
            try {
                if (!this.userUtil.getJiraAdministrators().isEmpty()) {
                    return this.EXISTING_ADMINS;
                }
                try {
                    administrator = this.userService.createUserNoNotification(this.result);
                }
                catch (PermissionException e) {
                    this.addErrorMessage(this.getText("signup.error.group.database.immutable", this.result.getUsername()));
                }
                Group groupAdmins = this.getOrCreateGroup("jira-administrators");
                Group groupDevelopers = this.getOrCreateGroup("jira-developers");
                Group groupUsers = this.getOrCreateGroup("jira-users");
                if (administrator == null || groupAdmins == null || groupDevelopers == null || groupUsers == null) break block10;
                try {
                    for (Group group : new Group[]{groupAdmins, groupDevelopers, groupUsers}) {
                        if (this.groupManager.isUserInGroup(administrator, group)) continue;
                        this.groupManager.addUserToGroup(administrator, group);
                    }
                    this.addUserToApplicationsDefaultGroups(administrator);
                    this.associateDefaultGroupsWithLicensedApplications();
                }
                catch (CrowdException e) {
                    throw new RuntimeException(e);
                }
                if (!this.globalPermissionManager.getGroupNames(0).contains("jira-administrators")) {
                    this.globalPermissionManager.addPermission(0, "jira-administrators");
                }
                AdminAccessHelper accessHelper = new AdminAccessHelper(this.globalPermissionManager, this.applicationRoleManager, this.groupManager);
                accessHelper.associateAdminGroupsWithAppRole();
            }
            catch (CreateException e) {
                throw new RuntimeException(e);
            }
        }
        this.request.getSession().setAttribute(SetupAdminUserSessionStorage.SESSION_KEY, (Object)new SetupAdminUserSessionStorage(this.result.getUsername()));
        this.putSENIntoMetadata();
        return this.getResult();
    }

    @VisibleForTesting
    void addUserToApplicationsDefaultGroups(@Nonnull ApplicationUser user) throws CrowdException {
        Assertions.notNull((String)"user", (Object)user);
        for (Application application : this.applicationManager.getApplications()) {
            Group applicationDefaultGroup = this.getOrCreateGroup(application.getDefaultGroup());
            if (this.groupManager.isUserInGroup(user, applicationDefaultGroup)) continue;
            this.groupManager.addUserToGroup(user, applicationDefaultGroup);
        }
    }

    String getDefaultGroupName(ApplicationKey applicationKey) {
        Option appOption = this.applicationManager.getApplication(applicationKey);
        String groupName = (String)appOption.map(Application::getDefaultGroup).getOrNull();
        if (groupName == null) {
            groupName = applicationKey.toString() + "-users";
        }
        return groupName;
    }

    @VisibleForTesting
    void associateDefaultGroupsWithLicensedApplications() {
        Set licensedRoles = this.applicationRoleManager.getRoles();
        for (ApplicationRole role : licensedRoles) {
            String groupName = this.getDefaultGroupName(role.getKey());
            Group group = this.getOrCreateGroup(groupName);
            if (group == null) continue;
            HashSet<Group> defaultGroups = new HashSet<Group>(role.getDefaultGroups());
            defaultGroups.add(group);
            HashSet<Group> groups = new HashSet<Group>(role.getGroups());
            groups.add(group);
            this.applicationRoleManager.setRole(role.withGroups(groups, defaultGroups));
        }
    }

    private Group getOrCreateGroup(String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        try {
            return this.groupManager.createGroup(groupName);
        }
        catch (OperationNotPermittedException | InvalidGroupException e) {
            this.addErrorMessage(this.getText("signup.error.group.database.immutable", groupName));
            return null;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    private void putSENIntoMetadata() {
        if (!this.jiraLicenseService.getSupportEntitlementNumbers().isEmpty()) {
            this.webResourceManager.putMetadata("SEN", (String)this.jiraLicenseService.getSupportEntitlementNumbers().first());
        }
    }
}

