/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.user.UserProperty;
import org.apache.commons.lang.StringUtils;

public class EditUserProperty
extends UserProperty {
    public EditUserProperty(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
    }

    @Override
    protected String doExecute() throws Exception {
        if (this.key == null || StringUtils.isBlank((String)this.key) || !this.userPropertyKeyExists()) {
            this.addErrorMessage(this.getText("admin.errors.userproperty.non.existing.property"));
            return "invalidkey";
        }
        this.setValue(this.userPropertyManager.getPropertySet(this.getUser()).getString(this.getTrueKey()));
        return "input";
    }

    @RequiresXsrfCheck
    public String doUpdate() {
        if (StringUtils.isBlank((String)this.value)) {
            this.addError("value", this.getText("admin.errors.userproperty.value.empty"));
        } else if (this.value.length() > 250) {
            this.addError("value", this.getText("admin.errors.userproperty.value.too.long"));
        } else if (!this.userPropertyKeyExists()) {
            this.addErrorMessage(this.getText("admin.errors.userproperty.non.existing.property"));
        }
        if (this.invalidInput()) {
            this.retrieveUserMetaProperties();
            return "error";
        }
        this.userPropertyManager.getPropertySet(this.getUser()).setString(this.getTrueKey(), this.value);
        return this.returnComplete("EditUserProperties.jspa?name=" + JiraUrlCodec.encode((String)this.getName()));
    }

    private boolean userPropertyKeyExists() {
        return this.userPropertyManager.getPropertySet(this.getUser()).exists(this.getTrueKey());
    }
}

