/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.cluster;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeReplicatorService;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class ReplicationSettings
extends JiraWebActionSupport {
    protected final SecondaryJiraHome secondaryJiraHome;
    private final ClusterManager clusterManager;
    private final JiraHomeReplicatorService jiraHomeReplicatorService;
    private Boolean replicating;

    public ReplicationSettings(SecondaryJiraHome secondaryJiraHome, ClusterManager clusterManager, JiraHomeReplicatorService jiraHomeReplicatorService) {
        this.secondaryJiraHome = secondaryJiraHome;
        this.clusterManager = clusterManager;
        this.jiraHomeReplicatorService = jiraHomeReplicatorService;
    }

    protected String doExecute() throws Exception {
        if (this.isReplicateRequested()) {
            this.jiraHomeReplicatorService.replicateJiraHome();
        }
        return "success";
    }

    public boolean isReplicationEnabled() {
        return this.secondaryJiraHome.isEnabled();
    }

    public String getReplicationPath() {
        if (!this.isReplicationEnabled()) {
            return "";
        }
        return this.secondaryJiraHome.getHomePath();
    }

    public boolean isClusterLicensed() {
        return this.clusterManager.isClusterLicensed();
    }

    public boolean isReplicating() {
        if (this.replicating == null) {
            this.replicating = this.isReplicateRequested() || this.jiraHomeReplicatorService.isReplicating();
        }
        return this.replicating;
    }

    public boolean isReplicateRequested() {
        return this.getHttpRequest().getParameter("ReplicateRequested") != null;
    }
}

