/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.AdminAccessHelper;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConfirmNewInstallationWithOldLicense
extends JiraWebActionSupport {
    public static final String RADIO_OPTION_LICENSE = "license";
    public static final String RADIO_OPTION_EVALUATION = "evaluation";
    public static final String RADIO_OPTION_REMOVE_EXPIRED = "remove-expired";
    public static final String EXTERNAL_LINK_JIRA_LICENSE_VIEW_CLUSTERED = "external.link.jira.license.data.center.contact";
    public static final String EXTERNAL_LINK_JIRA_LICENSE_VIEW_TIMEBOMB = "external.link.jira.license.view.timebomb";
    public static final String CLUSTERED_TIMEBOMB_ANCHOR = "TimebombLicensesforTesting-TestingDataCentercompatibility";
    public static final String EXTERNAL_LINK_JIRA_LICENSE_VIEW = "external.link.jira.license.view";
    public static final String LICENSE_DESC_LINK_CONTENT = "licenseDescLinkContent";
    public static final String LICENSE_DESC_LINK_TIMEBOMB_CONTENT = "licenseDescLinkTimebombContent";
    private static final String CROWD_EMBEDDED_INTEGRATION_VERSION = "602";
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final AdminAccessHelper adminAccessHelper;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final CrowdService crowdService;
    private final GlobalPermissionManager permissionManager;
    private final ClusterManager clusterManager;
    private final UserManager userManager;
    private final JiraProperties jiraSystemProperties;
    private final JohnsonProvider johnsonProvider;
    private String userName;
    private String password;
    private String licenseString;
    private String radioOption;
    private boolean licenseUpdated = false;
    private boolean installationConfirmed = false;
    private List<LicenseDetails> licensesDetails;
    private JiraLicenseService.ValidationResult validationResult;
    private boolean loginInvalid = false;
    private boolean radioOptionInvalid = false;

    public ConfirmNewInstallationWithOldLicense(JiraLicenseUpdaterService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, AdminAccessHelper adminAccessHelper, JiraSystemRestarter jiraSystemRestarter, CrowdService crowdService, GlobalPermissionManager permissionManager, JiraProperties jiraSystemProperties, ClusterManager clusterManager, UserManager userManager, JohnsonProvider johnsonProvider) {
        this.crowdService = crowdService;
        this.clusterManager = clusterManager;
        this.johnsonProvider = johnsonProvider;
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.permissionManager = (GlobalPermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.adminAccessHelper = (AdminAccessHelper)Assertions.notNull((String)"adminAccessHelper", (Object)adminAccessHelper);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraSystemRestarter = (JiraSystemRestarter)Assertions.notNull((String)"jiraSystemRestarter", (Object)jiraSystemRestarter);
        this.jiraSystemProperties = jiraSystemProperties;
    }

    private boolean shouldDisplay() {
        return this.isPresentInJohnsonEventContainer(EventType.get((String)"license-too-old")) || this.isPresentInJohnsonEventContainer(EventType.get((String)"clustering-unlicensed")) || this.isPresentInJohnsonEventContainer(EventType.get((String)"subscription-expired"));
    }

    private boolean isPresentInJohnsonEventContainer(EventType eventType) {
        return this.getJohnsonEventContainer().getEvents().stream().anyMatch(event -> event != null && event.getKey().equals((Object)eventType));
    }

    private boolean isEvaluationOptionDisplayable() {
        if (this.clusterManager.isClustered()) {
            return false;
        }
        List<LicenseDetails> licensesDetails = this.getLicensesDetails();
        boolean expiredDataCenterOrEnterpriseAgreement = licensesDetails.stream().anyMatch(lic -> this.isLicensePastMaintenance((LicenseDetails)lic) && (lic.isDataCenter() || lic.isEnterpriseLicenseAgreement()));
        return !expiredDataCenterOrEnterpriseAgreement;
    }

    private boolean areThereLicensesWithinMaintenance() {
        List<LicenseDetails> licensesDetails = this.getLicensesDetails();
        return licensesDetails.stream().anyMatch(lic -> !this.isLicensePastMaintenance((LicenseDetails)lic));
    }

    public String doDefault() throws Exception {
        if (!this.shouldDisplay()) {
            return "securitybreach";
        }
        return "input";
    }

    protected void doValidation() {
        ApplicationUser user;
        if (!this.shouldDisplay()) {
            return;
        }
        if (StringUtils.isBlank((String)this.radioOption)) {
            this.log.warn((Object)"Neither the License nor the Install Confirmation have been supplied.");
            this.addErrorMessage(this.getText("admin.errors.no.license"));
            this.setRadioOptionInvalid(true);
            return;
        }
        if (this.getUserInfoAvailable() && ((user = this.getCrowdUser()) == null || this.nonAdminUpgradeAllowed() || !this.checkUserIsAdmin(user))) {
            return;
        }
        if (this.radioOption.equals(RADIO_OPTION_LICENSE)) {
            this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.licenseString);
            this.addErrorCollection(this.validationResult.getErrorCollection());
        } else if (this.radioOption.equals(RADIO_OPTION_REMOVE_EXPIRED) && this.adminAccessHelper.areThereAdminsWithoutAccess()) {
            this.addError("license-removal", this.getText("admin.license.remove.expired.error"));
        }
    }

    private boolean checkUserIsAdmin(ApplicationUser applicationUser) {
        boolean hasAdminPermission = this.permissionManager.hasPermission(0, applicationUser);
        if (!hasAdminPermission) {
            this.addErrorMessage(this.getText("admin.errors.no.admin.permission"));
            this.setLoginInvalid(true);
            return false;
        }
        return true;
    }

    private ApplicationUser getCrowdUser() {
        User user = this.crowdService.getUser(this.userName);
        if (user == null) {
            this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
            this.setLoginInvalid(true);
            return null;
        }
        try {
            this.crowdService.authenticate(this.userName, this.password);
            return ApplicationUsers.from(user);
        }
        catch (FailedAuthenticationException e) {
            this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
            this.setLoginInvalid(true);
            return null;
        }
    }

    protected String doExecute() throws Exception {
        if (!this.shouldDisplay()) {
            return "securitybreach";
        }
        Option<String> error = Option.none();
        if (this.radioOption.equals(RADIO_OPTION_LICENSE)) {
            error = this.executeNewLicense();
        } else if (this.radioOption.equals(RADIO_OPTION_REMOVE_EXPIRED)) {
            error = this.removeOutOfMaintenanceLicenses();
        } else if (this.radioOption.equals(RADIO_OPTION_EVALUATION)) {
            this.jiraLicenseService.confirmProceedUnderEvaluationTerms(this.userName);
            this.installationConfirmed = true;
        } else {
            throw new IllegalStateException("This will never happen!");
        }
        if (error.isDefined()) {
            return (String)error.get();
        }
        this.jiraSystemRestarter.ariseSirJIRA();
        JohnsonEventContainer cont = this.johnsonProvider.getContainer();
        for (Object o : cont.getEvents()) {
            Event event = (Event)o;
            if (event == null || !this.isLicenseEvent(event)) continue;
            cont.removeEvent(event);
        }
        cont.addEvent(new Event(EventType.get((String)"restart"), this.getText("system.error.restart.for.changes"), EventLevel.get((String)"fatal")));
        return "success";
    }

    private Option<String> executeNewLicense() {
        LicenseDetails licenseDetails = this.jiraLicenseService.setLicense(this.validationResult);
        if (!licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate())) {
            this.addError(RADIO_OPTION_LICENSE, this.getText("admin.errors.license.too.old"));
            return Option.option((Object)"error");
        }
        this.licenseUpdated = true;
        return Option.none();
    }

    private Option<String> removeOutOfMaintenanceLicenses() {
        LinkedList licensesToRemove = Lists.newLinkedList();
        for (LicenseDetails license : this.jiraLicenseService.getLicenses()) {
            if (!this.isLicensePastMaintenance(license)) continue;
            licensesToRemove.add(license);
        }
        if (!licensesToRemove.isEmpty()) {
            this.jiraLicenseService.removeLicenses((Iterable)licensesToRemove);
            this.adminAccessHelper.associateAdminGroupsWithAppRole();
            this.licenseUpdated = true;
        }
        return Option.none();
    }

    private boolean isLicensePastMaintenance(LicenseDetails license) {
        Date buildDate = this.buildUtilsInfo.getCurrentBuildDate();
        return !license.isMaintenanceValidForBuildDate(buildDate);
    }

    private boolean isLicenseEvent(Event event) {
        ArrayList events = Lists.newArrayList((Object[])new String[]{"license-too-old", "clustering-unlicensed", "subscription-expired"});
        return events.stream().anyMatch(m -> event.equals((Object)EventType.get((String)m)));
    }

    JohnsonEventContainer getJohnsonEventContainer() {
        return this.johnsonProvider.getContainer();
    }

    public List<LicenseDetails> getLicensesDetails() {
        if (this.licensesDetails == null) {
            this.licensesDetails = Lists.newArrayList((Iterable)this.jiraLicenseService.getLicenses());
        }
        return this.licensesDetails;
    }

    public Map<String, String> getLicensesStatusMessages() {
        List<LicenseDetails> licensesDetails = this.getLicensesDetails();
        HashMap<String, String> messages = new HashMap<String, String>();
        for (LicenseDetails licenseDetails : licensesDetails) {
            LicenseDetails.LicenseStatusMessage licenseStatusMessage = licenseDetails.getLicenseStatusMessage(this.getI18nHelper(), this.userManager);
            if (licenseStatusMessage == null) continue;
            messages.putAll(licenseStatusMessage.getAllMessages());
        }
        return messages;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLicense() {
        return this.licenseString;
    }

    public void setLicense(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getRadioOption() {
        return this.radioOption;
    }

    public void setRadioOption(String radioOption) {
        this.radioOption = radioOption;
    }

    public boolean getLoginInvalid() {
        return this.loginInvalid;
    }

    public void setLoginInvalid(boolean loginInvalid) {
        this.loginInvalid = loginInvalid;
    }

    public boolean getRadioOptionInvalid() {
        return this.radioOptionInvalid;
    }

    public void setRadioOptionInvalid(boolean radioOptionInvalid) {
        this.radioOptionInvalid = radioOptionInvalid;
    }

    private boolean nonAdminUpgradeAllowed() {
        return this.jiraSystemProperties.getBoolean("non.admin.upgrade");
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public String getCurrentBuildDate() {
        return this.getOutlookDate().formatDMY(this.buildUtilsInfo.getCurrentBuildDate());
    }

    public boolean getUserInfoAvailable() {
        BuildNumComparator comparator = new BuildNumComparator();
        if (comparator.compare(this.buildUtilsInfo.getCurrentBuildNumber(), CROWD_EMBEDDED_INTEGRATION_VERSION) < 0) {
            return true;
        }
        String currentDatabaseVersion = this.getApplicationProperties().getString("jira.version.patched");
        return !Strings.isNullOrEmpty((String)currentDatabaseVersion) && comparator.compare(currentDatabaseVersion, CROWD_EMBEDDED_INTEGRATION_VERSION) > 0;
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("serverId", this.getServerId());
        data.put("errors", this.getErrors());
        data.put("radioOption", this.getRadioOption());
        data.put("radioOptionLicense", RADIO_OPTION_LICENSE);
        data.put("radioOptionEvaluation", RADIO_OPTION_EVALUATION);
        data.put("radioRemoveExpired", RADIO_OPTION_REMOVE_EXPIRED);
        data.put("expired", this.isAnyLicenseExpired());
        data.put("evaluationOptionDisplayable", this.isEvaluationOptionDisplayable());
        data.put("clustered", this.clusterManager.isClustered());
        data.put("thereAreValidLicenses", this.areThereLicensesWithinMaintenance());
        ExternalLinkUtil externalLinkUtil = ExternalLinkUtilImpl.getInstance();
        if (this.clusterManager.isClustered()) {
            data.put(LICENSE_DESC_LINK_CONTENT, this.getAnchorTagForLink(externalLinkUtil, EXTERNAL_LINK_JIRA_LICENSE_VIEW_CLUSTERED, null));
            data.put(LICENSE_DESC_LINK_TIMEBOMB_CONTENT, this.getAnchorTagForLink(externalLinkUtil, EXTERNAL_LINK_JIRA_LICENSE_VIEW_TIMEBOMB, CLUSTERED_TIMEBOMB_ANCHOR));
        } else {
            String[] linkParams = new String[]{this.getBuildUtilsInfo().getVersion(), this.getBuildUtilsInfo().getCurrentBuildNumber(), "Enterprise", (String)data.get("serverId")};
            data.put(LICENSE_DESC_LINK_CONTENT, this.getAnchorTagForLink(externalLinkUtil, EXTERNAL_LINK_JIRA_LICENSE_VIEW, linkParams));
        }
        String generalErrorMessage = this.getErrorMessages().isEmpty() ? null : (String)this.getErrorMessages().iterator().next();
        data.put("loginErrorMessageContent", this.getLoginInvalid() ? generalErrorMessage : null);
        this.setLoginErrorMessageTitle(generalErrorMessage, data);
        data.put("radioOptionErrorMessageContent", this.getRadioOptionInvalid() ? generalErrorMessage : null);
        Map<String, String> licenseStatusMessages = this.getLicensesStatusMessages();
        if (licenseStatusMessages.get("admin.license.support.and.updates") != null) {
            data.put("licenseStatusMessage1Content", licenseStatusMessages.get("admin.license.support.and.updates"));
            data.put("licenseStatusMessage2Content", licenseStatusMessages.get("admin.license.renewal.target"));
        } else {
            data.put("licenseStatusMessage1Content", licenseStatusMessages.get("admin.license.evaluation"));
            data.put("licenseStatusMessage2Content", licenseStatusMessages.get("admin.license.evaluation.renew"));
        }
        data.put("userNameValue", this.getUserName());
        data.put("licenseValue", this.getLicense());
        data.put("jiraTitle", this.getApplicationProperties().getDefaultBackedString("jira.title"));
        data.put("jiraLogoUrl", this.getApplicationProperties().getDefaultBackedString("jira.lf.logo.url"));
        data.put("resourcesContent", MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath()));
        return data;
    }

    private boolean isAnyLicenseExpired() {
        return this.getLicensesDetails().stream().anyMatch(LicenseDetails::isExpired);
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getDataMapSuccess() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("licenseUpdated", this.licenseUpdated);
        data.put("installationConfirmed", this.installationConfirmed);
        data.put("jiraTitle", this.getApplicationProperties().getDefaultBackedString("jira.title"));
        data.put("jiraLogoUrl", this.getApplicationProperties().getDefaultBackedString("jira.lf.logo.url"));
        data.put("resourcesContent", MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath()));
        return data;
    }

    private void setLoginErrorMessageTitle(String generalErrorMessage, Map<String, Object> data) {
        if (StringUtils.equals((String)generalErrorMessage, (String)this.getText("admin.errors.no.admin.permission"))) {
            data.put("loginErrorMessageTitle", this.getLoginInvalid() ? this.getText("admin.errors.no.admin.permission.title") : null);
        }
    }

    private String getAnchorTagForLink(ExternalLinkUtil util, String link, Object linkParams) {
        if (linkParams != null) {
            return "<a href=\"" + util.getProperty(link, linkParams) + "\">";
        }
        return "<a href=\"" + util.getProperty(link) + "\">";
    }
}

