/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.onboarding.FirstUseFlow;
import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeLinker;
import com.atlassian.jira.security.login.LoginManagerImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class MyJiraHome
extends JiraWebActionSupport {
    private final MyJiraHomeLinker myJiraHomeLinker;
    private final UserManager userManager;
    private final OnboardingService onboardingService;

    public MyJiraHome(@Nonnull MyJiraHomeLinker myJiraHomeLinker, @Nonnull UserManager userManager, @Nonnull OnboardingService onboardingService) {
        this.myJiraHomeLinker = myJiraHomeLinker;
        this.userManager = userManager;
        this.onboardingService = onboardingService;
    }

    protected String doExecute() throws Exception {
        return this.getRedirect(this.findMyHome());
    }

    private String findMyHome() {
        ApplicationUser loggedInUser = this.getLoggedInUser();
        FirstUseFlow firstUseFlow = this.onboardingService.getFirstUseFlow(loggedInUser);
        if (firstUseFlow != null) {
            return firstUseFlow.getUrl();
        }
        if (loggedInUser != null) {
            return this.myJiraHomeLinker.getHomeLink(loggedInUser);
        }
        if (this.isKnownButUnauthorised()) {
            return this.myJiraHomeLinker.getDefaultUserHome();
        }
        return this.myJiraHomeLinker.getHomeLink(null);
    }

    private boolean isKnownButUnauthorised() {
        String userKeyStr;
        ApplicationUser user;
        Object userKey;
        HttpServletRequest httpRequest = this.getHttpRequest();
        return Boolean.TRUE.equals(httpRequest.getAttribute(LoginManagerImpl.AUTHORISED_FAILURE)) && (userKey = httpRequest.getAttribute(LoginManagerImpl.AUTHORISING_USER_KEY)) instanceof String && (user = this.userManager.getUserByKey(userKeyStr = (String)userKey)) != null;
    }
}

