/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.BridgedDirectoryUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class ApplicationUsers {
    @Nullable
    public static ApplicationUser from(@Nullable User user) {
        if (user == null) {
            return null;
        }
        if (user instanceof BridgedDirectoryUser) {
            return ((BridgedDirectoryUser)user).toApplicationUser();
        }
        String key = ComponentAccessor.getUserKeyService().getKeyForUsername(user.getName());
        if (key == null) {
            if (user.getDirectoryId() != -1L) {
                throw new IllegalStateException("User '" + user.getName() + "' has no unique key mapping.");
            }
            key = user.getName();
        }
        return new DelegatingApplicationUser(key, user);
    }

    @Nullable
    public static String getKeyFor(@Nullable User user) {
        if (user == null) {
            return null;
        }
        if (user instanceof BridgedDirectoryUser) {
            return ((BridgedDirectoryUser)user).toApplicationUser().getKey();
        }
        return ComponentAccessor.getUserKeyService().getKeyForUsername(user.getName());
    }

    @Nullable
    public static String getKeyFor(@Nullable ApplicationUser user) {
        return user == null ? null : user.getKey();
    }

    @Nullable
    public static User toDirectoryUser(@Nullable ApplicationUser user) {
        return user == null ? null : user.getDirectoryUser();
    }

    @Nullable
    public static List<ApplicationUser> from(@Nullable Collection<User> users) {
        if (users == null) {
            return null;
        }
        ArrayList<ApplicationUser> applicationUsers = new ArrayList<ApplicationUser>(users.size());
        for (User user : users) {
            applicationUsers.add(ApplicationUsers.from(user));
        }
        return applicationUsers;
    }

    @Nullable
    public static List<ApplicationUser> from(@Nullable Iterable<User> users) {
        if (users == null) {
            return null;
        }
        ArrayList<ApplicationUser> applicationUsers = new ArrayList<ApplicationUser>();
        for (User user : users) {
            applicationUsers.add(ApplicationUsers.from(user));
        }
        return applicationUsers;
    }

    @Nullable
    public static List<User> toDirectoryUsers(@Nullable Collection<ApplicationUser> applicationUsers) {
        if (applicationUsers == null) {
            return null;
        }
        ArrayList<User> users = new ArrayList<User>(applicationUsers.size());
        for (ApplicationUser applicationUser : applicationUsers) {
            users.add(ApplicationUsers.toDirectoryUser(applicationUser));
        }
        return users;
    }

    @Nullable
    public static ApplicationUser byKey(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return ComponentAccessor.getUserManager().getUserByKey(key);
    }
}

