/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.fugue.Option;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseUtils;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xABPServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.MoveJira6xTBPServiceDeskPermissions;
import com.atlassian.jira.upgrade.tasks.role.ServiceDeskPropertySetDao;

final class MoveJira6xServiceDeskPermissions
extends MigrationTask {
    private static final String PROPERTY_ABP_LICENSE = "ABP";
    private static final String PROPERTY_TBP_LICENSE = "TBP";
    private static final String PROPERTY_LICENSE_NONE = "none";
    private static final String PROPERTY_KEY_MIGRATION_LICENSE = "com.atlassian.servicedesk.renaissance.migration.type";
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier serviceDeskLicense;
    private final ServiceDeskPropertySetDao serviceDeskPropertySetDao;
    private final MoveJira6xTBPServiceDeskPermissions moveJira6XTBPServiceDeskPermissions;
    private final MoveJira6xABPServiceDeskPermissions moveJira6xABPServiceDeskPermissions;

    MoveJira6xServiceDeskPermissions(Jira6xServiceDeskPluginEncodedLicenseSupplier serviceDeskLicense, ServiceDeskPropertySetDao serviceDeskPropertySetDao, MoveJira6xTBPServiceDeskPermissions moveJira6XTBPServiceDeskPermissions, MoveJira6xABPServiceDeskPermissions moveJira6xABPServiceDeskPermissions) {
        this.serviceDeskLicense = serviceDeskLicense;
        this.serviceDeskPropertySetDao = serviceDeskPropertySetDao;
        this.moveJira6XTBPServiceDeskPermissions = moveJira6XTBPServiceDeskPermissions;
        this.moveJira6xABPServiceDeskPermissions = moveJira6xABPServiceDeskPermissions;
    }

    @Override
    MigrationState migrate(MigrationState state) {
        Option<String> encodedLicense = this.serviceDeskLicense.get();
        if (encodedLicense.isEmpty()) {
            return state.withAfterSaveTask(() -> this.setSdMigrationProperty(PROPERTY_LICENSE_NONE));
        }
        License license = new License((String)encodedLicense.get());
        LicenseUtils.ServiceDeskLicenseType licenseType = LicenseUtils.determineServiceDeskLicenseType(license);
        switch (licenseType) {
            case TierBasedPricing: {
                return this.moveJira6XTBPServiceDeskPermissions.migrate(state).withAfterSaveTask(() -> this.setSdMigrationProperty(PROPERTY_TBP_LICENSE));
            }
            case AgentBasedPricing: {
                return this.moveJira6xABPServiceDeskPermissions.migrate(state).withAfterSaveTask(() -> this.setSdMigrationProperty(PROPERTY_ABP_LICENSE));
            }
        }
        throw new MigrationFailedException("Unsupported service desk license type: " + (Object)((Object)licenseType));
    }

    private void setSdMigrationProperty(String migrationType) {
        this.serviceDeskPropertySetDao.writeStringProperty(PROPERTY_KEY_MIGRATION_LICENSE, migrationType);
    }
}

