/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationGroupService;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.upgrade.tasks.role.UserWithPermissions;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoveJira6xABPServiceDeskPermissions
extends MigrationTask {
    private static final String GROUP_ATTR_SERVICE_DESK = "synch.created.by.jira.service.desk";
    private static final String GROUP_ATTR_SERVICE_DESK_VALUE = "synch.created.by.jira.service.desk";
    private static final Group GROUP_SD_AGENTS = new ImmutableGroup("service-desk-agents");
    private static final Logger log = LoggerFactory.getLogger(MoveJira6xABPServiceDeskPermissions.class);
    private final MigrationGroupService migrationGroupService;
    private final GlobalPermissionDao globalPermissionDao;

    MoveJira6xABPServiceDeskPermissions(MigrationGroupService migrationGroupService, GlobalPermissionDao globalPermissionDao) {
        this.migrationGroupService = migrationGroupService;
        this.globalPermissionDao = globalPermissionDao;
    }

    @Override
    MigrationState migrate(MigrationState state) {
        Set<Group> sdAgentGroups = this.globalPermissionDao.groupsWithSdAgentPermission();
        for (Group sdAgentGroup : sdAgentGroups) {
            state = this.checkGroupAndMigrate(sdAgentGroup, state);
        }
        return state;
    }

    private MigrationState checkGroupAndMigrate(Group sdAgentGroup, MigrationState state) {
        Set<UserWithPermissions> usersInAgentGroup = this.migrationGroupService.getUsersInGroup(sdAgentGroup);
        boolean allUsersHaveUse = true;
        boolean anyUserHasUse = false;
        for (UserWithPermissions user : usersInAgentGroup) {
            if (!user.hasAdminPermission() && !user.hasUsePermission()) {
                allUsersHaveUse = false;
                break;
            }
            anyUserHasUse = true;
        }
        if (allUsersHaveUse) {
            return state.changeApplicationRole(ApplicationKeys.SERVICE_DESK, role -> this.migrateGroup((ApplicationRole)role, sdAgentGroup));
        }
        if (anyUserHasUse) {
            StringBuilder builder = new StringBuilder().append("Service Desk Migration - cannot add Service Desk application role to group: '").append(sdAgentGroup.getName()).append("'\n").append("Group contains users with misconfigured permissions - not all users in the group are ").append("able to login to JIRA, migration would cause privilege escalation.\n").append("Affected users:\n");
            String sep = "";
            for (UserWithPermissions user : usersInAgentGroup) {
                builder.append(sep).append(user.getUser().getName());
                sep = ", ";
            }
            log.info(builder.toString());
            return state;
        }
        return state;
    }

    private ApplicationRole migrateGroup(ApplicationRole applicationRole, Group sdAgentGroup) {
        ApplicationRole roleWithGroup = applicationRole.addGroup(sdAgentGroup);
        if (this.shouldSetGroupAsDefault(sdAgentGroup)) {
            roleWithGroup = roleWithGroup.addGroupAsDefault(sdAgentGroup);
        }
        return roleWithGroup;
    }

    private boolean shouldSetGroupAsDefault(Group sdAgentGroup) {
        GroupWithAttributes groupWithAttributes = this.migrationGroupService.getGroupWithAttributes(sdAgentGroup);
        boolean groupHasAdmin = this.globalPermissionDao.groupsWithAdminPermission().contains(sdAgentGroup);
        return !groupHasAdmin && groupWithAttributes != null && GROUP_SD_AGENTS.equals((Object)sdAgentGroup) && "synch.created.by.jira.service.desk".equals(groupWithAttributes.getValue("synch.created.by.jira.service.desk"));
    }
}

