/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.Licenses;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Set;

final class Move6xAdminPermissionOverToLicensedApplication
extends MigrationTask {
    private final GlobalPermissionDao permissionDao;

    Move6xAdminPermissionOverToLicensedApplication(GlobalPermissionDao permissionDao) {
        this.permissionDao = (GlobalPermissionDao)Assertions.notNull((String)"permissionDao", (Object)permissionDao);
    }

    @Override
    MigrationState migrate(MigrationState state) {
        Set<Group> adminGroups = this.permissionDao.groupsWithAdminPermission();
        if (adminGroups.isEmpty()) {
            return state;
        }
        Option<ApplicationKey> adminApplication = this.getAdminApplication(state.licenses());
        if (adminApplication.isEmpty()) {
            return state;
        }
        return state.changeApplicationRole((ApplicationKey)adminApplication.get(), role -> role.addGroups(adminGroups));
    }

    private Option<ApplicationKey> getAdminApplication(Licenses licenses) {
        Set<ApplicationKey> appKeys = licenses.keys();
        if (appKeys.contains(ApplicationKeys.CORE)) {
            return Option.some((Object)ApplicationKeys.CORE);
        }
        if (appKeys.contains(ApplicationKeys.SOFTWARE)) {
            return Option.some((Object)ApplicationKeys.SOFTWARE);
        }
        if (!appKeys.isEmpty()) {
            return Option.some((Object)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).onResultOf(ApplicationKey::value).min(appKeys));
        }
        return Option.none();
    }
}

