/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRoles;
import com.atlassian.jira.upgrade.tasks.role.Licenses;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class MigrationState {
    private final Licenses licenses;
    private final ApplicationRoles roles;
    private final ImmutableList<Runnable> afterSaveTasks;

    MigrationState(Licenses licenses, ApplicationRoles roles, ImmutableList<Runnable> afterSaveTasks) {
        this.roles = (ApplicationRoles)Assertions.notNull((String)"roles", (Object)roles);
        this.licenses = (Licenses)Assertions.notNull((String)"licenses", (Object)licenses);
        this.afterSaveTasks = (ImmutableList)Assertions.notNull((String)"afterSaveTasks", afterSaveTasks);
    }

    ApplicationRoles applicationRoles() {
        return this.roles;
    }

    Licenses licenses() {
        return this.licenses;
    }

    public ImmutableList<Runnable> afterSaveTasks() {
        return this.afterSaveTasks;
    }

    MigrationState changeLicenses(Function<Licenses, Licenses> action) {
        Assertions.notNull((String)"action", action);
        return new MigrationState(action.apply(this.licenses), this.roles, this.afterSaveTasks);
    }

    MigrationState withAfterSaveTask(Runnable afterSaveTask) {
        Assertions.notNull((String)"afterSaveTask", (Object)afterSaveTask);
        return new MigrationState(this.licenses, this.roles, (ImmutableList<Runnable>)ImmutableList.builder().addAll(this.afterSaveTasks).add((Object)afterSaveTask).build());
    }

    MigrationState changeApplicationRole(ApplicationKey key, Function<ApplicationRole, ApplicationRole> action) {
        Assertions.notNull((String)"action", action);
        Assertions.notNull((String)"key", (Object)key);
        Supplier supplier = () -> ApplicationRole.forKey(key);
        return new MigrationState(this.licenses, this.roles.put(action.apply((ApplicationRole)this.roles.get(key).getOrElse(supplier))), this.afterSaveTasks);
    }

    MigrationState changeEachRole(Function<ApplicationRole, ApplicationRole> action) {
        Assertions.notNull((String)"action", action);
        ApplicationRoles newRoles = this.roles;
        for (ApplicationRole role : this.roles.asMap().values()) {
            newRoles = newRoles.put(action.apply(role));
        }
        return new MigrationState(this.licenses, newRoles, this.afterSaveTasks);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationState state = (MigrationState)o;
        return this.licenses.equals(state.licenses) && this.roles.equals(state.roles);
    }

    public int hashCode() {
        int result = this.licenses.hashCode();
        result = 31 * result + this.roles.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("licenses", (Object)this.licenses).append("roles", (Object)this.roles).toString();
    }
}

