/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationGroupService;
import com.atlassian.jira.upgrade.tasks.role.UserWithPermissions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public final class MigrationGroupServiceImpl
implements MigrationGroupService {
    private final CrowdService crowdService;
    private final GlobalPermissionDao globalPermissionDao;

    public MigrationGroupServiceImpl(GlobalPermissionDao globalPermissionDao, CrowdService crowdService) {
        this.crowdService = crowdService;
        this.globalPermissionDao = globalPermissionDao;
    }

    @Override
    public GroupWithAttributes getGroupWithAttributes(Group group) {
        return this.crowdService.getGroupWithAttributes(group.getName());
    }

    @Override
    public Set<UserWithPermissions> getUsersInGroup(Group group) {
        return this.usersInTheGroup(group).stream().map(this::buildUserWithPermissions).collect(Collectors.toSet());
    }

    private Collection<User> usersInTheGroup(Group group) {
        Iterable usersIterable = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1));
        return ImmutableList.copyOf((Iterable)usersIterable);
    }

    private UserWithPermissions buildUserWithPermissions(User user) {
        boolean hasUse = this.globalPermissionDao.groupsWithUsePermission().stream().anyMatch(useGroup -> this.crowdService.isUserMemberOfGroup(user, useGroup));
        boolean hasAdmin = this.globalPermissionDao.groupsWithAdminPermission().stream().anyMatch(adminGroup -> this.crowdService.isUserMemberOfGroup(user, adminGroup));
        return new UserWithPermissions(user, hasUse, hasAdmin);
    }
}

