/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build843
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build843.class);
    private OfBizDelegator ofBizDelegator;
    private ConstantsManager constantsManager;
    private static final String iconFieldName = "iconurl";
    private static final Map<String, String> statusIconPaths = MapBuilder.newBuilder().add((Object)"/images/icons/status_assigned.gif", (Object)"/images/icons/statuses/assigned.png").add((Object)"/images/icons/status_closed.gif", (Object)"/images/icons/statuses/closed.png").add((Object)"/images/icons/status_document.gif", (Object)"/images/icons/statuses/document.png").add((Object)"/images/icons/status_down.gif", (Object)"/images/icons/statuses/down.png").add((Object)"/images/icons/status_email.gif", (Object)"/images/icons/statuses/email.png").add((Object)"/images/icons/status_generic.gif", (Object)"/images/icons/statuses/generic.png").add((Object)"/images/icons/status_information.gif", (Object)"/images/icons/statuses/information.png").add((Object)"/images/icons/status_inprogress.gif", (Object)"/images/icons/statuses/inprogress.png").add((Object)"/images/icons/status_invisible.gif", (Object)"/images/icons/statuses/invisible.png").add((Object)"/images/icons/status_needinfo.gif", (Object)"/images/icons/statuses/needinfo.png").add((Object)"/images/icons/status_open.gif", (Object)"/images/icons/statuses/open.png").add((Object)"/images/icons/status_reopened.gif", (Object)"/images/icons/statuses/reopened.png").add((Object)"/images/icons/status_resolved.gif", (Object)"/images/icons/statuses/resolved.png").add((Object)"/images/icons/status_trash.gif", (Object)"/images/icons/statuses/trash.png").add((Object)"/images/icons/status_unassigned.gif", (Object)"/images/icons/statuses/unassigned.png").add((Object)"/images/icons/status_up.gif", (Object)"/images/icons/statuses/up.png").add((Object)"/images/icons/status_visible.gif", (Object)"/images/icons/statuses/visible.png").toHashMap();
    private static final Map<String, String> issueTypeIconPaths = MapBuilder.newBuilder().add((Object)"/images/icons/bug.gif", (Object)"/images/icons/issuetypes/bug.png").add((Object)"/images/icons/improvement.gif", (Object)"/images/icons/issuetypes/improvement.png").add((Object)"/images/icons/newfeature.gif", (Object)"/images/icons/issuetypes/newfeature.png").add((Object)"/images/icons/task.gif", (Object)"/images/icons/issuetypes/task.png").add((Object)"/images/icons/genericissue.gif", (Object)"/images/icons/issuetypes/genericissue.png").add((Object)"/images/icons/blank.gif", (Object)"/images/icons/issuetypes/blank.png").add((Object)"/images/icons/delete.gif", (Object)"/images/icons/issuetypes/delete.png").add((Object)"/images/icons/documentation.gif", (Object)"/images/icons/issuetypes/documentation.png").add((Object)"/images/icons/exclamation.gif", (Object)"/images/icons/issuetypes/exclamation.png").add((Object)"/images/icons/health.gif", (Object)"/images/icons/issuetypes/health.png").add((Object)"/images/icons/removefeature.gif", (Object)"/images/icons/issuetypes/remove_feature.png").add((Object)"/images/icons/requirement.gif", (Object)"/images/icons/issuetypes/requirement.png").add((Object)"/images/icons/sales.gif", (Object)"/images/icons/issuetypes/sales.png").add((Object)"/images/icons/subtask.gif", (Object)"/images/icons/issuetypes/subtask.png").add((Object)"/images/icons/undefined.gif", (Object)"/images/icons/issuetypes/undefined.png").add((Object)"/images/icons/ico_defect.png", (Object)"/images/icons/issuetypes/defect.png").add((Object)"/images/icons/ico_epic.png", (Object)"/images/icons/issuetypes/epic.png").add((Object)"/images/icons/ico_story.png", (Object)"/images/icons/issuetypes/story.png").add((Object)"/images/icons/ico_task.png", (Object)"/images/icons/issuetypes/task_agile.png").toHashMap();
    private static final Map<String, String> priorityIconPaths = MapBuilder.newBuilder().add((Object)"/images/icons/priority_blocker.gif", (Object)"/images/icons/priorities/blocker.png").add((Object)"/images/icons/priority_critical.gif", (Object)"/images/icons/priorities/critical.png").add((Object)"/images/icons/priority_major.gif", (Object)"/images/icons/priorities/major.png").add((Object)"/images/icons/priority_minor.gif", (Object)"/images/icons/priorities/minor.png").add((Object)"/images/icons/priority_trivial.gif", (Object)"/images/icons/priorities/trivial.png").toHashMap();
    private static final Map<String, String> subtaskIconPaths = MapBuilder.newBuilder().add((Object)"/images/icons/issue_subtask.gif", (Object)"/images/icons/issuetypes/subtask_alternate.png").toHashMap();

    public UpgradeTask_Build843(OfBizDelegator ofBizDelegator, ConstantsManager constantsManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.constantsManager = constantsManager;
    }

    @Override
    public String getBuildNumber() {
        return "843";
    }

    @Override
    public String getShortDescription() {
        return "Updating file paths of default icons for statuses, issue types, priorities and sub-tasks.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.upgradeIconPathsForEntity("IssueType", issueTypeIconPaths);
        this.upgradeIconPathsForEntity("IssueType", subtaskIconPaths);
        this.upgradeIconPathsForEntity("Status", statusIconPaths);
        this.upgradeIconPathsForEntity("Priority", priorityIconPaths);
        this.constantsManager.refresh();
    }

    private void upgradeIconPathsForEntity(String entityName, Map<String, String> iconPaths) throws GenericEntityException {
        ArrayList<String> oldIconPaths = new ArrayList<String>(iconPaths.keySet());
        EntityExpr entityCondition = new EntityExpr(iconFieldName, EntityOperator.IN, oldIconPaths);
        List iconsToUpdate = this.ofBizDelegator.findByCondition(entityName, (EntityCondition)entityCondition, (Collection)CollectionBuilder.list((Object[])new String[]{"id", iconFieldName}), null);
        log.debug("Found " + iconsToUpdate.size() + " '" + entityName + "' icons with a default icon url.");
        for (GenericValue gv : iconsToUpdate) {
            UpgradeTask_Build843.changeIconPath(gv, iconPaths);
        }
    }

    private static void changeIconPath(GenericValue gv, Map<String, String> iconPaths) throws GenericEntityException {
        if (gv == null) {
            log.warn("Cannot update null generic value.");
        } else {
            String currentPath = gv.getString(iconFieldName);
            if (StringUtils.isBlank((String)currentPath)) {
                log.warn("Current icon url for '" + gv.getString("id") + "' was blank. Skipping.");
                return;
            }
            String newPath = iconPaths.get(currentPath);
            if (StringUtils.isBlank((String)newPath)) {
                log.warn("Current icon url '" + currentPath + "' has no corresponding new url. Skipping.");
                return;
            }
            log.debug("Updating icon url of '" + gv.getString("id") + "' from '" + currentPath + "' to '" + newPath + "'.");
            gv.setString(iconFieldName, newPath);
            gv.store();
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "813";
    }
}

