/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.OfbizExternalEntityStore;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build756
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build756.class);
    private static final String ENTITY_TYPE = OfbizExternalEntityStore.class.getName();
    private static final String NAME = "name";
    private final OfBizDelegator ofBizDelegator;
    private final UserManager userManager;

    public UpgradeTask_Build756(OfBizDelegator ofBizDelegator, UserManager userManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.userManager = userManager;
    }

    @Override
    public String getBuildNumber() {
        return "756";
    }

    @Override
    public String getShortDescription() {
        return "JRA-26194: usernames in UserPropertyManager should be stored lower case only. Update the storage.";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        Map<String, Object> externalEntityParameters = new PrimitiveMap.Builder().add("type", ENTITY_TYPE).toMap();
        List entities = this.ofBizDelegator.findByAnd("ExternalEntity", externalEntityParameters);
        if (entities != null) {
            LOG.info(String.format("Analysing %d External Entities...", entities.size()));
            HashMap<String, GenericValue> nameMap = new HashMap<String, GenericValue>(entities.size());
            ArrayList<Object> rowsToDelete = new ArrayList<Object>();
            for (GenericValue genericValue : entities) {
                String name = genericValue.getString(NAME);
                String lowerName = IdentifierUtils.toLowerCase((String)name);
                if (!nameMap.containsKey(lowerName)) {
                    nameMap.put(lowerName, genericValue);
                    continue;
                }
                ApplicationUser user = this.userManager.getUser(name);
                if (user != null && name.equals(user.getName())) {
                    rowsToDelete.add(nameMap.get(lowerName));
                    nameMap.put(lowerName, genericValue);
                    continue;
                }
                rowsToDelete.add(genericValue);
            }
            for (GenericValue genericValue : rowsToDelete) {
                this.ofBizDelegator.removeValue(genericValue);
            }
            for (Map.Entry entry : nameMap.entrySet()) {
                String lowername = (String)entry.getKey();
                GenericValue gv = (GenericValue)entry.getValue();
                if (gv.getString(NAME).equals(lowername)) continue;
                gv.setString(NAME, lowername);
                this.ofBizDelegator.store(gv);
            }
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "755";
    }
}

