/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build754
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build754.class);
    private final OfBizDelegator delegator;

    public UpgradeTask_Build754(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "754";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        boolean reindexRequired = false;
        List requests = this.delegator.findAll("SearchRequest");
        if (requests == null || requests.isEmpty()) {
            return;
        }
        LOG.info(String.format("Analysing %d Search Requests...", requests.size()));
        for (GenericValue gv : requests) {
            boolean store = UpgradeTask_Build754.fixUserColumn(gv, "user") | UpgradeTask_Build754.fixUserColumn(gv, "author");
            if (store) {
                this.delegator.store(gv);
            }
            reindexRequired |= store;
        }
        if (reindexRequired) {
            this.getReindexRequestService().requestReindex(ReindexRequestType.IMMEDIATE, EnumSet.of(AffectedIndex.SHAREDENTITY), EnumSet.of(SharedEntityType.SEARCH_REQUEST));
        }
    }

    private static boolean fixUserColumn(GenericValue gv, String columnName) {
        String lowercase_username;
        String username = gv.getString(columnName);
        if (StringUtils.isNotEmpty((String)username) && !username.equals(lowercase_username = IdentifierUtils.toLowerCase((String)username))) {
            gv.setString(columnName, lowercase_username);
            return true;
        }
        return false;
    }

    @Override
    public String getShortDescription() {
        return "Make the owner and author of a filter lowercase";
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "753";
    }

    private static final class Column {
        private static final String AUTHOR = "author";
        private static final String USER = "user";

        private Column() {
        }
    }

    private static final class Table {
        static final String NAME = "SearchRequest";

        private Table() {
        }
    }
}

