/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.CachingPortletConfigurationStore;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build64015
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build64015.class);
    private static final String BUGZILLA_GADGET_URI = "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:bugzilla/gadgets/bugzilla-id-search.xml";
    private static final String GADGET_TABLE = "PortletConfiguration";
    private static final String GADGET_URI_COLUMN = "gadgetXml";
    private final OfBizDelegator ofBizDelegator;
    private final CachingPortletConfigurationStore cachingPortletConfigurationStore;

    public UpgradeTask_Build64015(OfBizDelegator ofBizDelegator, CachingPortletConfigurationStore cachingPortletConfigurationStore) {
        this.ofBizDelegator = ofBizDelegator;
        this.cachingPortletConfigurationStore = cachingPortletConfigurationStore;
    }

    @Override
    public String getBuildNumber() {
        return "64015";
    }

    @Override
    public String getShortDescription() {
        return "Removing the JIRA Bugzilla ID search gadget.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        try {
            DateTime startedAt = new DateTime();
            int deletedGadgets = Delete.from(GADGET_TABLE).whereLike(GADGET_URI_COLUMN, BUGZILLA_GADGET_URI).execute(this.ofBizDelegator);
            log.debug(String.format("Upgrade task took %d seconds to remove %d bugzilla gadgets.", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds(), deletedGadgets));
        }
        finally {
            this.cachingPortletConfigurationStore.flush();
        }
    }
}

