/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build64002
extends AbstractDelayableUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build64002.class);
    private static final String NEWS_GADGET_URI = "http://www.atlassian.com/gadgets/news.xml";
    private static final String GADGET_TABLE = "PortletConfiguration";
    private static final String GADGET_URI_COLUMN = "gadgetXml";
    private final OfBizDelegator ofBizDelegator;

    public UpgradeTask_Build64002(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "64002";
    }

    @Override
    public String getShortDescription() {
        return "Removing the JIRA News gadget.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        DateTime startedAt = new DateTime();
        int deletedGadgets = Delete.from(GADGET_TABLE).whereLike(GADGET_URI_COLUMN, NEWS_GADGET_URI).execute(this.ofBizDelegator);
        log.info(String.format("Upgrade task took %d seconds to remove %d news gadgets.", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds(), deletedGadgets));
    }
}

