/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6211
extends AbstractImmediateUpgradeTask {
    public static final String USERS_PROJECT_ROLE_ID = "10000";
    public static final String DEVELOPERS_PROJECT_ROLE_ID = "10001";
    private final OfBizDelegator ofBizDelegator;
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6211.class);

    public UpgradeTask_Build6211(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "6211";
    }

    @Override
    public String getShortDescription() {
        return "JDEV-26606 Modify permissions schemes to allow project role 'Users' to link issues if they can comment, only if both permissions are still like in the default permission scheme.";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        List permissionSchemesGVs = this.ofBizDelegator.findAll("PermissionScheme");
        for (GenericValue scheme : permissionSchemesGVs) {
            try {
                List linkPermissionSchemeGVs;
                Long schemeId = scheme.getLong("id");
                List commentPermissionSchemeGVs = this.ofBizDelegator.findByAnd("SchemePermissions", (Map)ImmutableMap.of((Object)"scheme", (Object)schemeId, (Object)"permission", (Object)15, (Object)"type", (Object)"projectrole"));
                if (commentPermissionSchemeGVs.size() != 1 || !((GenericValue)commentPermissionSchemeGVs.get(0)).getString("parameter").equals(USERS_PROJECT_ROLE_ID) || (linkPermissionSchemeGVs = this.ofBizDelegator.findByAnd("SchemePermissions", (Map)ImmutableMap.of((Object)"scheme", (Object)schemeId, (Object)"permission", (Object)21, (Object)"type", (Object)"projectrole"))).size() != 1 || !((GenericValue)linkPermissionSchemeGVs.get(0)).getString("parameter").equals(DEVELOPERS_PROJECT_ROLE_ID)) continue;
                log.info("Updating role to 'Users' in scheme '" + scheme.getString("name") + "' for link issue permission");
                GenericValue permissionSchemeGV = (GenericValue)linkPermissionSchemeGVs.get(0);
                permissionSchemeGV.setString("parameter", USERS_PROJECT_ROLE_ID);
                this.ofBizDelegator.store(permissionSchemeGV);
            }
            catch (RuntimeException e) {
                log.warn("Unable to update scheme '" + scheme.getString("name") + "' to allow project role 'Users' to link issues", (Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6210";
    }
}

