/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.upgrade.tasks.AbstractReindexUpgradeTask;
import java.sql.Connection;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6208
extends AbstractReindexUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6208.class);
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6208(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6208";
    }

    @Override
    public String getShortDescription() {
        return "Populates the issue creator field";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        try (Connection connection = null;){
            connection = this.getDatabaseConnection();
            this.copyReporterToCreator(connection);
            this.fixUpChangedReporters();
        }
        this.getReindexRequestService().requestReindex(ReindexRequestType.DELAYED, EnumSet.of(AffectedIndex.ISSUE), EnumSet.noneOf(SharedEntityType.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReporterToCreator(Connection connection) throws Exception {
        try (Statement updateStmt = null;){
            String updateSql = "UPDATE " + this.convertToSchemaTableName("jiraissue") + " SET creator = reporter";
            updateStmt = connection.prepareStatement(updateSql);
            int updatedCount = updateStmt.executeUpdate();
            log.info(String.format("Updated %d issues.", updatedCount));
        }
    }

    private void fixUpChangedReporters() {
        List reporterChanges = Select.from("ChangeGroupChangeItemView").whereEqual("field", "reporter").orderBy("changegroupid desc").runWith(this.entityEngine).asList();
        for (GenericValue change : reporterChanges) {
            long issueId = change.getLong("issue");
            String reporter = change.getString("oldvalue");
            this.entityEngine.execute(Update.into("Issue").set("creator", reporter).whereEqual("id", issueId));
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6207";
    }
}

