/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6133
extends AbstractImmediateUpgradeTask {
    private static final String PLUGIN_STATE_ENTITY = "PluginState";

    @Override
    public String getShortDescription() {
        return "Migrate PluginPersistentState to the PluginState table";
    }

    @Override
    public String getBuildNumber() {
        return "6133";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Collection pluginStateKeys = this.getApplicationProperties().getStringsWithPrefix("jira.plugin.state-");
        this.doMigrate(pluginStateKeys);
        this.removeKeysFromPropertiesTable(pluginStateKeys);
    }

    private void doMigrate(Collection<String> pluginStateKeys) {
        try {
            this.storeGenericValue(pluginStateKeys);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    private void storeGenericValue(Collection<String> pluginStateKeys) throws GenericEntityException {
        ArrayList gvs = Lists.newArrayList();
        String target = "jira.plugin.state-.";
        for (String pluginStateKey : pluginStateKeys) {
            GenericValue gv = UpgradeTask_Build6133.getOfBizDelegator().makeValue(PLUGIN_STATE_ENTITY);
            gv.set("key", (Object)pluginStateKey.replace("jira.plugin.state-.", ""));
            gv.set("enabled", (Object)this.getApplicationProperties().getString(pluginStateKey));
            gvs.add(gv);
        }
        UpgradeTask_Build6133.getOfBizDelegator().storeAll((List)gvs);
    }

    private void removeKeysFromPropertiesTable(Collection<String> pluginStateKeys) {
        for (String key : pluginStateKeys) {
            this.getApplicationProperties().setString(key, null);
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6132";
    }
}

