/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6132
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6132.class);

    @Override
    public String getShortDescription() {
        return "Adding a unique constraint to the issue table for project and issue number pair";
    }

    @Override
    public String getBuildNumber() {
        return "6132";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        GenericHelper helper = this.getDelegator().getEntityHelper("Issue");
        DatabaseUtil dbUtil = new DatabaseUtil(helper.getHelperName());
        ModelEntity issueEntity = this.getDelegator().getModelEntity("Issue");
        ModelIndex projNumIndex = new ModelIndex();
        projNumIndex.setName("issue_proj_num");
        projNumIndex.setMainEntity(issueEntity);
        projNumIndex.setUnique(true);
        projNumIndex.addIndexField("number");
        projNumIndex.addIndexField("project");
        this.dropIndex(dbUtil, issueEntity, projNumIndex);
        this.createIndex(dbUtil, issueEntity, projNumIndex);
    }

    private void createIndex(DatabaseUtil dbUtil, ModelEntity issueEntity, ModelIndex projNumIndex) {
        String error = dbUtil.createDeclaredIndex(issueEntity, projNumIndex);
        if (error != null) {
            log.error("Update failed. Read more about possible reason: https://confluence.atlassian.com/display/JIRAKB/Upgrading+To+JIRA+6.1+Fails+Due+To+Duplicate+Issue+Keys");
            throw new RuntimeException("Could not create index: " + error);
        }
    }

    private void dropIndex(DatabaseUtil dbUtil, ModelEntity issueEntity, ModelIndex projNumIndex) {
        String error = dbUtil.deleteDeclaredIndex(issueEntity, issueEntity.getIndex(projNumIndex.getName()));
        if (error != null) {
            throw new RuntimeException("Could not drop index: " + error);
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6131";
    }
}

