/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build608
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build608.class);
    private AvatarManager avatarManager;
    private ApplicationProperties applicationProperties;
    private final OfBizDelegator ofBizDelegator;
    private final UserPropertyManager userPropertyManager;

    public UpgradeTask_Build608(AvatarManager avatarManager, ApplicationProperties applicationProperties, OfBizDelegator ofBizDelegator, UserPropertyManager userPropertyManager) {
        this.avatarManager = avatarManager;
        this.applicationProperties = applicationProperties;
        this.ofBizDelegator = ofBizDelegator;
        this.userPropertyManager = userPropertyManager;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        ArrayList<Long> systemAvatarIds = new ArrayList<Long>();
        for (Avatar avatar : this.avatarManager.getAllSystemAvatars(Avatar.Type.USER)) {
            systemAvatarIds.add(avatar.getId());
        }
        for (int i = 1; i <= 22; ++i) {
            this.createAvatar("Avatar-" + i + ".png");
        }
        Avatar defaultAvatar = this.createAvatar("Avatar-default.png");
        this.applicationProperties.setString("jira.avatar.user.default.id", defaultAvatar.getId().toString());
        Avatar anonymousAvatar = this.createAvatar("Avatar-unknown.png");
        this.applicationProperties.setString("jira.avatar.user.anonymous.id", anonymousAvatar.getId().toString());
        EntityConditionList entityCondition = new EntityConditionList(Arrays.asList(new EntityExpr("propertyKey", EntityOperator.EQUALS, (Object)"user.avatar.id"), new EntityExpr("propertyValue", EntityOperator.IN, systemAvatarIds)), EntityOperator.AND);
        List propertiesToUpdate = this.ofBizDelegator.findByCondition("OSUserPropertySetNumberView", (EntityCondition)entityCondition, (Collection)CollectionBuilder.list((Object[])new String[]{"id"}));
        ArrayList<Long> primaryKeys = new ArrayList<Long>();
        for (GenericValue genericValue : propertiesToUpdate) {
            primaryKeys.add(genericValue.getLong("id"));
        }
        this.ofBizDelegator.bulkUpdateByPrimaryKey("OSPropertyNumber", MapBuilder.singletonMap((Object)"value", (Object)defaultAvatar.getId()), primaryKeys);
        for (Long systemAvatarId : systemAvatarIds) {
            this.avatarManager.delete(systemAvatarId);
        }
        OfBizPropertyEntryStore store = (OfBizPropertyEntryStore)ComponentAccessor.getComponent(OfBizPropertyEntryStore.class);
        if (store instanceof CachingOfBizPropertyEntryStore) {
            ((CachingOfBizPropertyEntryStore)store).onClearCache(null);
        } else {
            String name = store != null ? store.getClass().getName() : "null";
            log.error("Expected to find a CachingOfBizPropertyEntryStore, but got " + name);
        }
    }

    private Avatar createAvatar(String fileName) {
        log.info("Creating system user avatar " + fileName);
        return this.avatarManager.create((Avatar)AvatarImpl.createSystemAvatar(fileName, "image/png", Avatar.Type.USER));
    }

    @Override
    public String getShortDescription() {
        return "Updating system user avatars.";
    }

    @Override
    public String getBuildNumber() {
        return "608";
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "606";
    }
}

