/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.FindMixedCaseUsernames;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6047
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build6047.class);
    static final String OAUTH_SP_TOKEN_ENTITY = "OAuthServiceProviderToken";
    static final String USERNAME = "username";
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6047(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6047";
    }

    @Override
    public String getShortDescription() {
        return "Convert usernames to lowercase in oauthsptoken table.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Select.SelectColumnsFromContext<String> fieldQuery = Select.distinctString(USERNAME).from(OAUTH_SP_TOKEN_ENTITY);
        Map<String, String> usernameMap = this.entityEngine.run(fieldQuery).consumeWith(FindMixedCaseUsernames.fromStrings());
        if (usernameMap.isEmpty()) {
            return;
        }
        LOG.info(String.format("Analysing %d OAuthServiceProviderTokens...", usernameMap.size()));
        for (Map.Entry<String, String> entry : usernameMap.entrySet()) {
            this.entityEngine.execute(Update.into(OAUTH_SP_TOKEN_ENTITY).set(USERNAME, entry.getValue()).whereEqual(USERNAME, entry.getKey()));
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6045";
    }
}

