/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

public class UpgradeManagerParams {
    private final boolean setupMode;
    private final boolean allowReindex;
    private final boolean withoutDelay;

    private UpgradeManagerParams(boolean setupMode, boolean allowReindex, boolean withoutDelay) {
        this.setupMode = setupMode;
        this.allowReindex = allowReindex;
        this.withoutDelay = withoutDelay;
    }

    public boolean isSetupMode() {
        return this.setupMode;
    }

    public boolean isAllowReindex() {
        return this.allowReindex;
    }

    public boolean isWithoutDelay() {
        return this.withoutDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeManagerParams that = (UpgradeManagerParams)o;
        if (this.allowReindex != that.allowReindex) {
            return false;
        }
        return this.setupMode == that.setupMode;
    }

    public int hashCode() {
        int result = this.setupMode ? 1 : 0;
        result = 31 * result + (this.allowReindex ? 1 : 0);
        return result;
    }

    public static class Builder {
        private boolean setupMode = false;
        private boolean allowReindex = true;
        private boolean withoutDelay = false;

        public Builder setSetupMode(boolean setupMode) {
            this.setupMode = setupMode;
            return this;
        }

        public Builder setAllowReindex(boolean allowReindex) {
            this.allowReindex = allowReindex;
            return this;
        }

        public Builder setWithoutDelay(boolean withoutDelay) {
            this.withoutDelay = withoutDelay;
            return this;
        }

        public Builder withSetupMode() {
            this.setupMode = true;
            return this;
        }

        public Builder withoutReindexAllowed() {
            this.allowReindex = false;
            return this;
        }

        public Builder withoutDelay() {
            this.withoutDelay = true;
            return this;
        }

        public UpgradeManagerParams build() {
            return new UpgradeManagerParams(this.setupMode, this.allowReindex, this.withoutDelay);
        }
    }
}

